@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Devbox disk encryption enable or disable status. Indicates if Devbox disks encryption using DevCenter CMK is enabled or not.
 */
public enum class DevboxDisksEncryptionEnableStatus(
    public val javaValue: com.pulumi.azurenative.devcenter.enums.DevboxDisksEncryptionEnableStatus,
) : ConvertibleToJava<com.pulumi.azurenative.devcenter.enums.DevboxDisksEncryptionEnableStatus> {
    Enabled(com.pulumi.azurenative.devcenter.enums.DevboxDisksEncryptionEnableStatus.Enabled),
    Disabled(com.pulumi.azurenative.devcenter.enums.DevboxDisksEncryptionEnableStatus.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.devcenter.enums.DevboxDisksEncryptionEnableStatus =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devcenter.enums.DevboxDisksEncryptionEnableStatus): DevboxDisksEncryptionEnableStatus =
            DevboxDisksEncryptionEnableStatus.values().first { it.javaValue == javaType }
    }
}
