@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Indicates whether owners of Dev Boxes in this pool are added as local administrators on the Dev Box.
 */
public enum class LocalAdminStatus(
    public val javaValue: com.pulumi.azurenative.devcenter.enums.LocalAdminStatus,
) : ConvertibleToJava<com.pulumi.azurenative.devcenter.enums.LocalAdminStatus> {
    Disabled(com.pulumi.azurenative.devcenter.enums.LocalAdminStatus.Disabled),
    Enabled(com.pulumi.azurenative.devcenter.enums.LocalAdminStatus.Enabled),
    ;

    override fun toJava(): com.pulumi.azurenative.devcenter.enums.LocalAdminStatus = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devcenter.enums.LocalAdminStatus): LocalAdminStatus = LocalAdminStatus.values().first { it.javaValue == javaType }
    }
}
