@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin.inputs

import com.pulumi.azurenative.devcenter.inputs.GetCatalogDevBoxDefinitionErrorDetailsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property catalogName The name of the Catalog.
 * @property devBoxDefinitionName The name of the Dev Box definition.
 * @property devCenterName The name of the devcenter.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetCatalogDevBoxDefinitionErrorDetailsPlainArgs(
    public val catalogName: String,
    public val devBoxDefinitionName: String,
    public val devCenterName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.devcenter.inputs.GetCatalogDevBoxDefinitionErrorDetailsPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.devcenter.inputs.GetCatalogDevBoxDefinitionErrorDetailsPlainArgs =
        com.pulumi.azurenative.devcenter.inputs.GetCatalogDevBoxDefinitionErrorDetailsPlainArgs.builder()
            .catalogName(catalogName.let({ args0 -> args0 }))
            .devBoxDefinitionName(devBoxDefinitionName.let({ args0 -> args0 }))
            .devCenterName(devCenterName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCatalogDevBoxDefinitionErrorDetailsPlainArgs].
 */
@PulumiTagMarker
public class GetCatalogDevBoxDefinitionErrorDetailsPlainArgsBuilder internal constructor() {
    private var catalogName: String? = null

    private var devBoxDefinitionName: String? = null

    private var devCenterName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Catalog.
     */
    @JvmName("nroclyalkuqaxadx")
    public suspend fun catalogName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.catalogName = mapped
    }

    /**
     * @param value The name of the Dev Box definition.
     */
    @JvmName("jqaiyrxxaiyghptp")
    public suspend fun devBoxDefinitionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.devBoxDefinitionName = mapped
    }

    /**
     * @param value The name of the devcenter.
     */
    @JvmName("maxsoxgswtihexaq")
    public suspend fun devCenterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.devCenterName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("brndvtavtrygkvfd")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetCatalogDevBoxDefinitionErrorDetailsPlainArgs =
        GetCatalogDevBoxDefinitionErrorDetailsPlainArgs(
            catalogName = catalogName ?: throw PulumiNullFieldException("catalogName"),
            devBoxDefinitionName = devBoxDefinitionName ?: throw
                PulumiNullFieldException("devBoxDefinitionName"),
            devCenterName = devCenterName ?: throw PulumiNullFieldException("devCenterName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
