@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin.inputs

import com.pulumi.azurenative.devcenter.inputs.GetCustomizationTaskErrorDetailsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property catalogName The name of the Catalog.
 * @property devCenterName The name of the devcenter.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property taskName The name of the Task.
 */
public data class GetCustomizationTaskErrorDetailsPlainArgs(
    public val catalogName: String,
    public val devCenterName: String,
    public val resourceGroupName: String,
    public val taskName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.devcenter.inputs.GetCustomizationTaskErrorDetailsPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.devcenter.inputs.GetCustomizationTaskErrorDetailsPlainArgs =
        com.pulumi.azurenative.devcenter.inputs.GetCustomizationTaskErrorDetailsPlainArgs.builder()
            .catalogName(catalogName.let({ args0 -> args0 }))
            .devCenterName(devCenterName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .taskName(taskName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCustomizationTaskErrorDetailsPlainArgs].
 */
@PulumiTagMarker
public class GetCustomizationTaskErrorDetailsPlainArgsBuilder internal constructor() {
    private var catalogName: String? = null

    private var devCenterName: String? = null

    private var resourceGroupName: String? = null

    private var taskName: String? = null

    /**
     * @param value The name of the Catalog.
     */
    @JvmName("dlvxdwaxoxkgtath")
    public suspend fun catalogName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.catalogName = mapped
    }

    /**
     * @param value The name of the devcenter.
     */
    @JvmName("evketopvybkhhpuo")
    public suspend fun devCenterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.devCenterName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qbgusnqpkratnmkg")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Task.
     */
    @JvmName("ughghpiqdboxgunk")
    public suspend fun taskName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.taskName = mapped
    }

    internal fun build(): GetCustomizationTaskErrorDetailsPlainArgs =
        GetCustomizationTaskErrorDetailsPlainArgs(
            catalogName = catalogName ?: throw PulumiNullFieldException("catalogName"),
            devCenterName = devCenterName ?: throw PulumiNullFieldException("devCenterName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            taskName = taskName ?: throw PulumiNullFieldException("taskName"),
        )
}
