@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin.inputs

import com.pulumi.azurenative.devcenter.inputs.GetEncryptionSetPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property devCenterName The name of the devcenter.
 * @property encryptionSetName The name of the devcenter encryption set.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetEncryptionSetPlainArgs(
    public val devCenterName: String,
    public val encryptionSetName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.devcenter.inputs.GetEncryptionSetPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.devcenter.inputs.GetEncryptionSetPlainArgs =
        com.pulumi.azurenative.devcenter.inputs.GetEncryptionSetPlainArgs.builder()
            .devCenterName(devCenterName.let({ args0 -> args0 }))
            .encryptionSetName(encryptionSetName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEncryptionSetPlainArgs].
 */
@PulumiTagMarker
public class GetEncryptionSetPlainArgsBuilder internal constructor() {
    private var devCenterName: String? = null

    private var encryptionSetName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the devcenter.
     */
    @JvmName("exgwpouerafatcvn")
    public suspend fun devCenterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.devCenterName = mapped
    }

    /**
     * @param value The name of the devcenter encryption set.
     */
    @JvmName("iirfvwiraxwellgm")
    public suspend fun encryptionSetName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.encryptionSetName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hhcxhosqcnpsrric")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetEncryptionSetPlainArgs = GetEncryptionSetPlainArgs(
        devCenterName = devCenterName ?: throw PulumiNullFieldException("devCenterName"),
        encryptionSetName = encryptionSetName ?: throw PulumiNullFieldException("encryptionSetName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
