@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin.inputs

import com.pulumi.azurenative.devcenter.inputs.GetPlanMemberPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property memberName The name of a devcenter plan member.
 * @property planName The name of the devcenter plan.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetPlanMemberPlainArgs(
    public val memberName: String,
    public val planName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.devcenter.inputs.GetPlanMemberPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.devcenter.inputs.GetPlanMemberPlainArgs =
        com.pulumi.azurenative.devcenter.inputs.GetPlanMemberPlainArgs.builder()
            .memberName(memberName.let({ args0 -> args0 }))
            .planName(planName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPlanMemberPlainArgs].
 */
@PulumiTagMarker
public class GetPlanMemberPlainArgsBuilder internal constructor() {
    private var memberName: String? = null

    private var planName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of a devcenter plan member.
     */
    @JvmName("kkgahdougdwrocgm")
    public suspend fun memberName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.memberName = mapped
    }

    /**
     * @param value The name of the devcenter plan.
     */
    @JvmName("cuyqtptuebssbalt")
    public suspend fun planName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.planName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wchpmsstgyckhflo")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPlanMemberPlainArgs = GetPlanMemberPlainArgs(
        memberName = memberName ?: throw PulumiNullFieldException("memberName"),
        planName = planName ?: throw PulumiNullFieldException("planName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
