@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin.inputs

import com.pulumi.azurenative.devcenter.inputs.GetPlanPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property planName The name of the devcenter plan.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetPlanPlainArgs(
    public val planName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.devcenter.inputs.GetPlanPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.devcenter.inputs.GetPlanPlainArgs =
        com.pulumi.azurenative.devcenter.inputs.GetPlanPlainArgs.builder()
            .planName(planName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPlanPlainArgs].
 */
@PulumiTagMarker
public class GetPlanPlainArgsBuilder internal constructor() {
    private var planName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the devcenter plan.
     */
    @JvmName("gtcmckpldduxxbob")
    public suspend fun planName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.planName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ofntdfgkmpgtkycm")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPlanPlainArgs = GetPlanPlainArgs(
        planName = planName ?: throw PulumiNullFieldException("planName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
