@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin.inputs

import com.pulumi.azurenative.devcenter.inputs.GetSchedulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property poolName Name of the pool.
 * @property projectName The name of the project.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property scheduleName The name of the schedule that uniquely identifies it.
 * @property top The maximum number of resources to return from the operation. Example: '$top=10'.
 */
public data class GetSchedulePlainArgs(
    public val poolName: String,
    public val projectName: String,
    public val resourceGroupName: String,
    public val scheduleName: String,
    public val top: Int? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devcenter.inputs.GetSchedulePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.devcenter.inputs.GetSchedulePlainArgs =
        com.pulumi.azurenative.devcenter.inputs.GetSchedulePlainArgs.builder()
            .poolName(poolName.let({ args0 -> args0 }))
            .projectName(projectName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .scheduleName(scheduleName.let({ args0 -> args0 }))
            .top(top?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSchedulePlainArgs].
 */
@PulumiTagMarker
public class GetSchedulePlainArgsBuilder internal constructor() {
    private var poolName: String? = null

    private var projectName: String? = null

    private var resourceGroupName: String? = null

    private var scheduleName: String? = null

    private var top: Int? = null

    /**
     * @param value Name of the pool.
     */
    @JvmName("ctuuwnsmcusfwcyf")
    public suspend fun poolName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.poolName = mapped
    }

    /**
     * @param value The name of the project.
     */
    @JvmName("slqcajktnrcifjpx")
    public suspend fun projectName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.projectName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("odsbwchmruawjxcv")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the schedule that uniquely identifies it.
     */
    @JvmName("rxayoueccexqqsdq")
    public suspend fun scheduleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.scheduleName = mapped
    }

    /**
     * @param value The maximum number of resources to return from the operation. Example: '$top=10'.
     */
    @JvmName("fjnhmedgehqgghdy")
    public suspend fun top(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.top = mapped
    }

    internal fun build(): GetSchedulePlainArgs = GetSchedulePlainArgs(
        poolName = poolName ?: throw PulumiNullFieldException("poolName"),
        projectName = projectName ?: throw PulumiNullFieldException("projectName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        scheduleName = scheduleName ?: throw PulumiNullFieldException("scheduleName"),
        top = top,
    )
}
