@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin.inputs

import com.pulumi.azurenative.devcenter.inputs.ProjectEnvironmentTypeUpdatePropertiesCreatorRoleAssignmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The role definition assigned to the environment creator on backing resources.
 * @property roles A map of roles to assign to the environment creator.
 */
public data class ProjectEnvironmentTypeUpdatePropertiesCreatorRoleAssignmentArgs(
    public val roles: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.devcenter.inputs.ProjectEnvironmentTypeUpdatePropertiesCreatorRoleAssignmentArgs> {
    override fun toJava(): com.pulumi.azurenative.devcenter.inputs.ProjectEnvironmentTypeUpdatePropertiesCreatorRoleAssignmentArgs =
        com.pulumi.azurenative.devcenter.inputs.ProjectEnvironmentTypeUpdatePropertiesCreatorRoleAssignmentArgs.builder()
            .roles(roles?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ProjectEnvironmentTypeUpdatePropertiesCreatorRoleAssignmentArgs].
 */
@PulumiTagMarker
public class ProjectEnvironmentTypeUpdatePropertiesCreatorRoleAssignmentArgsBuilder internal constructor() {
    private var roles: Output<List<String>>? = null

    /**
     * @param value A map of roles to assign to the environment creator.
     */
    @JvmName("vjfpnyejkixnohnm")
    public suspend fun roles(`value`: Output<List<String>>) {
        this.roles = value
    }

    @JvmName("utkbogmdflwifxfj")
    public suspend fun roles(vararg values: Output<String>) {
        this.roles = Output.all(values.asList())
    }

    /**
     * @param values A map of roles to assign to the environment creator.
     */
    @JvmName("otdiymvrhkxgmrna")
    public suspend fun roles(values: List<Output<String>>) {
        this.roles = Output.all(values)
    }

    /**
     * @param value A map of roles to assign to the environment creator.
     */
    @JvmName("nrnhfglvpyinyjoe")
    public suspend fun roles(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roles = mapped
    }

    /**
     * @param values A map of roles to assign to the environment creator.
     */
    @JvmName("gdktbwgdlkjanttt")
    public suspend fun roles(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roles = mapped
    }

    internal fun build(): ProjectEnvironmentTypeUpdatePropertiesCreatorRoleAssignmentArgs =
        ProjectEnvironmentTypeUpdatePropertiesCreatorRoleAssignmentArgs(
            roles = roles,
        )
}
