@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * An individual synchronization error.
 * @property errorDetails Errors associated with the file.
 * @property path The path of the file the error is associated with.
 */
public data class CatalogSyncErrorResponse(
    public val errorDetails: List<CatalogErrorDetailsResponse>,
    public val path: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devcenter.outputs.CatalogSyncErrorResponse): CatalogSyncErrorResponse = CatalogSyncErrorResponse(
            errorDetails = javaType.errorDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devcenter.kotlin.outputs.CatalogErrorDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            path = javaType.path(),
        )
    }
}
