@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Project catalog settings for project catalogs under a project associated to this dev center.
 * @property catalogItemSyncEnableStatus Whether project catalogs associated with projects in this dev center can be configured to sync catalog items.
 */
public data class DevCenterProjectCatalogSettingsResponse(
    public val catalogItemSyncEnableStatus: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devcenter.outputs.DevCenterProjectCatalogSettingsResponse): DevCenterProjectCatalogSettingsResponse = DevCenterProjectCatalogSettingsResponse(
            catalogItemSyncEnableStatus = javaType.catalogItemSyncEnableStatus().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
