@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Represents a catalog.
 * @property adoGit Properties for an Azure DevOps catalog type.
 * @property gitHub Properties for a GitHub catalog type.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property lastSyncTime When the catalog was last synced.
 * @property name The name of the resource
 * @property provisioningState The provisioning state of the resource.
 * @property syncState The synchronization state of the catalog.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetCatalogResult(
    public val adoGit: GitCatalogResponse? = null,
    public val gitHub: GitCatalogResponse? = null,
    public val id: String,
    public val lastSyncTime: String,
    public val name: String,
    public val provisioningState: String,
    public val syncState: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devcenter.outputs.GetCatalogResult): GetCatalogResult = GetCatalogResult(
            adoGit = javaType.adoGit().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devcenter.kotlin.outputs.GitCatalogResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            gitHub = javaType.gitHub().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devcenter.kotlin.outputs.GitCatalogResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            lastSyncTime = javaType.lastSyncTime(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            syncState = javaType.syncState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.devcenter.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
