@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * List of validator error details. Populated when changes are made to the resource or its dependent resources that impact the validity of the Catalog resource.
 * @property errors Errors associated with resources synchronized from the catalog.
 */
public data class GetCustomizationTaskErrorDetailsResult(
    public val errors: List<CatalogErrorDetailsResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devcenter.outputs.GetCustomizationTaskErrorDetailsResult): GetCustomizationTaskErrorDetailsResult = GetCustomizationTaskErrorDetailsResult(
            errors = javaType.errors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devcenter.kotlin.outputs.CatalogErrorDetailsResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
