@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Represents a definition for a Developer Machine.
 * @property activeImageReference Image reference information for the currently active image (only populated during updates).
 * @property hibernateSupport Indicates whether Dev Boxes created with this definition are capable of hibernation. Not all images are capable of supporting hibernation. To find out more see https://aka.ms/devbox/hibernate
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property imageReference Image reference information.
 * @property imageValidationErrorDetails Details for image validator error. Populated when the image validation is not successful.
 * @property imageValidationStatus Validation status of the configured image.
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property osStorageType The storage type used for the Operating System disk of Dev Boxes created using this definition.
 * @property provisioningState The provisioning state of the resource.
 * @property sku The SKU for Dev Boxes created using this definition.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetDevBoxDefinitionResult(
    public val activeImageReference: ImageReferenceResponse,
    public val hibernateSupport: String? = null,
    public val id: String,
    public val imageReference: ImageReferenceResponse,
    public val imageValidationErrorDetails: ImageValidationErrorDetailsResponse,
    public val imageValidationStatus: String,
    public val location: String,
    public val name: String,
    public val osStorageType: String? = null,
    public val provisioningState: String,
    public val sku: SkuResponse,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devcenter.outputs.GetDevBoxDefinitionResult): GetDevBoxDefinitionResult = GetDevBoxDefinitionResult(
            activeImageReference = javaType.activeImageReference().let({ args0 ->
                com.pulumi.azurenative.devcenter.kotlin.outputs.ImageReferenceResponse.Companion.toKotlin(args0)
            }),
            hibernateSupport = javaType.hibernateSupport().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            imageReference = javaType.imageReference().let({ args0 ->
                com.pulumi.azurenative.devcenter.kotlin.outputs.ImageReferenceResponse.Companion.toKotlin(args0)
            }),
            imageValidationErrorDetails = javaType.imageValidationErrorDetails().let({ args0 ->
                com.pulumi.azurenative.devcenter.kotlin.outputs.ImageValidationErrorDetailsResponse.Companion.toKotlin(args0)
            }),
            imageValidationStatus = javaType.imageValidationStatus(),
            location = javaType.location(),
            name = javaType.name(),
            osStorageType = javaType.osStorageType().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            sku = javaType.sku().let({ args0 ->
                com.pulumi.azurenative.devcenter.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.devcenter.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
