@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin.outputs

import kotlin.Suppress

/**
 * Applicable inherited settings for a project.
 * @property networkSettings Network settings that will be enforced on this project.
 * @property projectCatalogSettings Dev Center settings to be used when associating a project with a catalog.
 */
public data class GetProjectInheritedSettingsResult(
    public val networkSettings: ProjectNetworkSettingsResponse,
    public val projectCatalogSettings: DevCenterProjectCatalogSettingsResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devcenter.outputs.GetProjectInheritedSettingsResult): GetProjectInheritedSettingsResult = GetProjectInheritedSettingsResult(
            networkSettings = javaType.networkSettings().let({ args0 ->
                com.pulumi.azurenative.devcenter.kotlin.outputs.ProjectNetworkSettingsResponse.Companion.toKotlin(args0)
            }),
            projectCatalogSettings = javaType.projectCatalogSettings().let({ args0 ->
                com.pulumi.azurenative.devcenter.kotlin.outputs.DevCenterProjectCatalogSettingsResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
