@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Pool health status detail.
 * @property code An identifier for the issue.
 * @property message A message describing the issue, intended to be suitable for display in a user interface
 */
public data class HealthStatusDetailResponse(
    public val code: String,
    public val message: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devcenter.outputs.HealthStatusDetailResponse): HealthStatusDetailResponse = HealthStatusDetailResponse(
            code = javaType.code(),
            message = javaType.message(),
        )
    }
}
