@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Image reference information
 * @property exactVersion The actual version of the image after use. When id references a gallery image latest version, this will indicate the actual version in use.
 * @property id Image ID, or Image version ID. When Image ID is provided, its latest version will be used.
 */
public data class ImageReferenceResponse(
    public val exactVersion: String,
    public val id: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devcenter.outputs.ImageReferenceResponse): ImageReferenceResponse = ImageReferenceResponse(
            exactVersion = javaType.exactVersion(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
        )
    }
}
