@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Network settings for the project.
 * @property microsoftHostedNetworkEnableStatus Indicates whether pools in this Dev Center can use Microsoft Hosted Networks. Defaults to Enabled if not set.
 */
public data class ProjectNetworkSettingsResponse(
    public val microsoftHostedNetworkEnableStatus: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devcenter.outputs.ProjectNetworkSettingsResponse): ProjectNetworkSettingsResponse = ProjectNetworkSettingsResponse(
            microsoftHostedNetworkEnableStatus = javaType.microsoftHostedNetworkEnableStatus(),
        )
    }
}
