@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Stop on disconnect configuration settings for Dev Boxes created in this pool.
 * @property gracePeriodMinutes The specified time in minutes to wait before stopping a Dev Box once disconnect is detected.
 * @property status Whether the feature to stop the Dev Box on disconnect once the grace period has lapsed is enabled.
 */
public data class StopOnDisconnectConfigurationResponse(
    public val gracePeriodMinutes: Int? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devcenter.outputs.StopOnDisconnectConfigurationResponse): StopOnDisconnectConfigurationResponse = StopOnDisconnectConfigurationResponse(
            gracePeriodMinutes = javaType.gracePeriodMinutes().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
