@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Mapping of user object ID to role assignments.
 * @property roles A map of roles to assign to the parent user.
 */
public data class UserRoleAssignmentResponse(
    public val roles: Map<String, EnvironmentRoleResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devcenter.outputs.UserRoleAssignmentResponse): UserRoleAssignmentResponse = UserRoleAssignmentResponse(
            roles = javaType.roles().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.devcenter.kotlin.outputs.EnvironmentRoleResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
        )
    }
}
