@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devhub.kotlin

import com.pulumi.azurenative.devhub.kotlin.outputs.IacTemplatePropertiesResponse
import com.pulumi.azurenative.devhub.kotlin.outputs.StagePropertiesResponse
import com.pulumi.azurenative.devhub.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.devhub.kotlin.outputs.IacTemplatePropertiesResponse.Companion.toKotlin as iacTemplatePropertiesResponseToKotlin
import com.pulumi.azurenative.devhub.kotlin.outputs.StagePropertiesResponse.Companion.toKotlin as stagePropertiesResponseToKotlin
import com.pulumi.azurenative.devhub.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [IacProfile].
 */
@PulumiTagMarker
public class IacProfileResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IacProfileArgs = IacProfileArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IacProfileArgsBuilder.() -> Unit) {
        val builder = IacProfileArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): IacProfile {
        val builtJavaResource = com.pulumi.azurenative.devhub.IacProfile(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return IacProfile(builtJavaResource)
    }
}

/**
 * Resource representation of a IacProfile.
 * Azure REST API version: 2024-05-01-preview.
 * ## Example Usage
 * ### Create IacProfile
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var iacProfile = new AzureNative.DevHub.IacProfile("iacProfile", new()
 *     {
 *         IacProfileName = "profile1",
 *         Location = "location1",
 *         RepositoryMainBranch = "main",
 *         RepositoryName = "localtest",
 *         RepositoryOwner = "owner",
 *         ResourceGroupName = "resourceGroup1",
 *         Stages = new[]
 *         {
 *             new AzureNative.DevHub.Inputs.StagePropertiesArgs
 *             {
 *                 Dependencies = new() { },
 *                 GitEnvironment = "Terraform",
 *                 StageName = "dev",
 *             },
 *             new AzureNative.DevHub.Inputs.StagePropertiesArgs
 *             {
 *                 Dependencies = new[]
 *                 {
 *                     "dev",
 *                 },
 *                 GitEnvironment = "Terraform",
 *                 StageName = "qa",
 *             },
 *             new AzureNative.DevHub.Inputs.StagePropertiesArgs
 *             {
 *                 Dependencies = new[]
 *                 {
 *                     "qa",
 *                 },
 *                 GitEnvironment = "Terraform",
 *                 StageName = "prod",
 *             },
 *         },
 *         StorageAccountName = "hybridiac",
 *         StorageAccountResourceGroup = "hybrid-iac",
 *         StorageAccountSubscription = "subscription",
 *         StorageContainerName = "hybridiac",
 *         Tags =
 *         {
 *             { "appname", "testApp" },
 *         },
 *         Templates = new[]
 *         {
 *             new AzureNative.DevHub.Inputs.IacTemplatePropertiesArgs
 *             {
 *                 InstanceName = "contoso",
 *                 InstanceStage = "dev",
 *                 SourceResourceId = "/subscriptions/xxxx/resourceGroups/xxxx",
 *                 TemplateDetails = new[]
 *                 {
 *                     new AzureNative.DevHub.Inputs.IacTemplateDetailsArgs
 *                     {
 *                         Count = 1,
 *                         NamingConvention = "$sitid-hci",
 *                         ProductName = "HCI",
 *                     },
 *                     new AzureNative.DevHub.Inputs.IacTemplateDetailsArgs
 *                     {
 *                         Count = 1,
 *                         NamingConvention = "$sitid-aks",
 *                         ProductName = "AKSarc",
 *                     },
 *                 },
 *                 TemplateName = "base",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devhub/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devhub.NewIacProfile(ctx, "iacProfile", &devhub.IacProfileArgs{
 * 			IacProfileName:       pulumi.String("profile1"),
 * 			Location:             pulumi.String("location1"),
 * 			RepositoryMainBranch: pulumi.String("main"),
 * 			RepositoryName:       pulumi.String("localtest"),
 * 			RepositoryOwner:      pulumi.String("owner"),
 * 			ResourceGroupName:    pulumi.String("resourceGroup1"),
 * 			Stages: devhub.StagePropertiesArray{
 * 				&devhub.StagePropertiesArgs{
 * 					Dependencies:   pulumi.StringArray{},
 * 					GitEnvironment: pulumi.String("Terraform"),
 * 					StageName:      pulumi.String("dev"),
 * 				},
 * 				&devhub.StagePropertiesArgs{
 * 					Dependencies: pulumi.StringArray{
 * 						pulumi.String("dev"),
 * 					},
 * 					GitEnvironment: pulumi.String("Terraform"),
 * 					StageName:      pulumi.String("qa"),
 * 				},
 * 				&devhub.StagePropertiesArgs{
 * 					Dependencies: pulumi.StringArray{
 * 						pulumi.String("qa"),
 * 					},
 * 					GitEnvironment: pulumi.String("Terraform"),
 * 					StageName:      pulumi.String("prod"),
 * 				},
 * 			},
 * 			StorageAccountName:          pulumi.String("hybridiac"),
 * 			StorageAccountResourceGroup: pulumi.String("hybrid-iac"),
 * 			StorageAccountSubscription:  pulumi.String("subscription"),
 * 			StorageContainerName:        pulumi.String("hybridiac"),
 * 			Tags: pulumi.StringMap{
 * 				"appname": pulumi.String("testApp"),
 * 			},
 * 			Templates: devhub.IacTemplatePropertiesArray{
 * 				&devhub.IacTemplatePropertiesArgs{
 * 					InstanceName:     pulumi.String("contoso"),
 * 					InstanceStage:    pulumi.String("dev"),
 * 					SourceResourceId: pulumi.String("/subscriptions/xxxx/resourceGroups/xxxx"),
 * 					TemplateDetails: devhub.IacTemplateDetailsArray{
 * 						&devhub.IacTemplateDetailsArgs{
 * 							Count:            pulumi.Int(1),
 * 							NamingConvention: pulumi.String("$sitid-hci"),
 * 							ProductName:      pulumi.String("HCI"),
 * 						},
 * 						&devhub.IacTemplateDetailsArgs{
 * 							Count:            pulumi.Int(1),
 * 							NamingConvention: pulumi.String("$sitid-aks"),
 * 							ProductName:      pulumi.String("AKSarc"),
 * 						},
 * 					},
 * 					TemplateName: pulumi.String("base"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devhub.IacProfile;
 * import com.pulumi.azurenative.devhub.IacProfileArgs;
 * import com.pulumi.azurenative.devhub.inputs.StagePropertiesArgs;
 * import com.pulumi.azurenative.devhub.inputs.IacTemplatePropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var iacProfile = new IacProfile("iacProfile", IacProfileArgs.builder()
 *             .iacProfileName("profile1")
 *             .location("location1")
 *             .repositoryMainBranch("main")
 *             .repositoryName("localtest")
 *             .repositoryOwner("owner")
 *             .resourceGroupName("resourceGroup1")
 *             .stages(
 *                 StagePropertiesArgs.builder()
 *                     .dependencies()
 *                     .gitEnvironment("Terraform")
 *                     .stageName("dev")
 *                     .build(),
 *                 StagePropertiesArgs.builder()
 *                     .dependencies("dev")
 *                     .gitEnvironment("Terraform")
 *                     .stageName("qa")
 *                     .build(),
 *                 StagePropertiesArgs.builder()
 *                     .dependencies("qa")
 *                     .gitEnvironment("Terraform")
 *                     .stageName("prod")
 *                     .build())
 *             .storageAccountName("hybridiac")
 *             .storageAccountResourceGroup("hybrid-iac")
 *             .storageAccountSubscription("subscription")
 *             .storageContainerName("hybridiac")
 *             .tags(Map.of("appname", "testApp"))
 *             .templates(IacTemplatePropertiesArgs.builder()
 *                 .instanceName("contoso")
 *                 .instanceStage("dev")
 *                 .sourceResourceId("/subscriptions/xxxx/resourceGroups/xxxx")
 *                 .templateDetails(
 *                     IacTemplateDetailsArgs.builder()
 *                         .count(1)
 *                         .namingConvention("$sitid-hci")
 *                         .productName("HCI")
 *                         .build(),
 *                     IacTemplateDetailsArgs.builder()
 *                         .count(1)
 *                         .namingConvention("$sitid-aks")
 *                         .productName("AKSarc")
 *                         .build())
 *                 .templateName("base")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devhub:IacProfile profile1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevHub/iacProfiles/{iacProfileName}
 * ```
 */
public class IacProfile internal constructor(
    override val javaResource: com.pulumi.azurenative.devhub.IacProfile,
) : KotlinCustomResource(javaResource, IacProfileMapper) {
    /**
     * Determines the authorization status of requests.
     */
    public val authStatus: Output<String>
        get() = javaResource.authStatus().applyValue({ args0 -> args0 })

    /**
     * Repository Branch Name
     */
    public val branchName: Output<String>?
        get() = javaResource.branchName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The status of the Pull Request submitted against the users repository.
     */
    public val prStatus: Output<String>
        get() = javaResource.prStatus().applyValue({ args0 -> args0 })

    /**
     * The number associated with the submitted pull request.
     */
    public val pullNumber: Output<Int>
        get() = javaResource.pullNumber().applyValue({ args0 -> args0 })

    /**
     * Repository Main Branch
     */
    public val repositoryMainBranch: Output<String>?
        get() = javaResource.repositoryMainBranch().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Repository Name
     */
    public val repositoryName: Output<String>?
        get() = javaResource.repositoryName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Repository Owner
     */
    public val repositoryOwner: Output<String>?
        get() = javaResource.repositoryOwner().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val stages: Output<List<StagePropertiesResponse>>?
        get() = javaResource.stages().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> stagePropertiesResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Terraform Storage Account Name
     */
    public val storageAccountName: Output<String>?
        get() = javaResource.storageAccountName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Terraform Storage Account Resource Group
     */
    public val storageAccountResourceGroup: Output<String>?
        get() = javaResource.storageAccountResourceGroup().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Terraform Storage Account Subscription
     */
    public val storageAccountSubscription: Output<String>?
        get() = javaResource.storageAccountSubscription().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Terraform Container Name
     */
    public val storageContainerName: Output<String>?
        get() = javaResource.storageContainerName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    public val templates: Output<List<IacTemplatePropertiesResponse>>?
        get() = javaResource.templates().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> iacTemplatePropertiesResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object IacProfileMapper : ResourceMapper<IacProfile> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.devhub.IacProfile::class == javaResource::class

    override fun map(javaResource: Resource): IacProfile = IacProfile(
        javaResource as
            com.pulumi.azurenative.devhub.IacProfile,
    )
}

/**
 * @see [IacProfile].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IacProfile].
 */
public suspend fun iacProfile(name: String, block: suspend IacProfileResourceBuilder.() -> Unit): IacProfile {
    val builder = IacProfileResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IacProfile].
 * @param name The _unique_ name of the resulting resource.
 */
public fun iacProfile(name: String): IacProfile {
    val builder = IacProfileResourceBuilder()
    builder.name(name)
    return builder.build()
}
