@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devhub.kotlin

import com.pulumi.azurenative.devhub.IacProfileArgs.builder
import com.pulumi.azurenative.devhub.kotlin.inputs.IacTemplatePropertiesArgs
import com.pulumi.azurenative.devhub.kotlin.inputs.IacTemplatePropertiesArgsBuilder
import com.pulumi.azurenative.devhub.kotlin.inputs.StagePropertiesArgs
import com.pulumi.azurenative.devhub.kotlin.inputs.StagePropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource representation of a IacProfile.
 * Azure REST API version: 2024-05-01-preview.
 * ## Example Usage
 * ### Create IacProfile
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var iacProfile = new AzureNative.DevHub.IacProfile("iacProfile", new()
 *     {
 *         IacProfileName = "profile1",
 *         Location = "location1",
 *         RepositoryMainBranch = "main",
 *         RepositoryName = "localtest",
 *         RepositoryOwner = "owner",
 *         ResourceGroupName = "resourceGroup1",
 *         Stages = new[]
 *         {
 *             new AzureNative.DevHub.Inputs.StagePropertiesArgs
 *             {
 *                 Dependencies = new() { },
 *                 GitEnvironment = "Terraform",
 *                 StageName = "dev",
 *             },
 *             new AzureNative.DevHub.Inputs.StagePropertiesArgs
 *             {
 *                 Dependencies = new[]
 *                 {
 *                     "dev",
 *                 },
 *                 GitEnvironment = "Terraform",
 *                 StageName = "qa",
 *             },
 *             new AzureNative.DevHub.Inputs.StagePropertiesArgs
 *             {
 *                 Dependencies = new[]
 *                 {
 *                     "qa",
 *                 },
 *                 GitEnvironment = "Terraform",
 *                 StageName = "prod",
 *             },
 *         },
 *         StorageAccountName = "hybridiac",
 *         StorageAccountResourceGroup = "hybrid-iac",
 *         StorageAccountSubscription = "subscription",
 *         StorageContainerName = "hybridiac",
 *         Tags =
 *         {
 *             { "appname", "testApp" },
 *         },
 *         Templates = new[]
 *         {
 *             new AzureNative.DevHub.Inputs.IacTemplatePropertiesArgs
 *             {
 *                 InstanceName = "contoso",
 *                 InstanceStage = "dev",
 *                 SourceResourceId = "/subscriptions/xxxx/resourceGroups/xxxx",
 *                 TemplateDetails = new[]
 *                 {
 *                     new AzureNative.DevHub.Inputs.IacTemplateDetailsArgs
 *                     {
 *                         Count = 1,
 *                         NamingConvention = "$sitid-hci",
 *                         ProductName = "HCI",
 *                     },
 *                     new AzureNative.DevHub.Inputs.IacTemplateDetailsArgs
 *                     {
 *                         Count = 1,
 *                         NamingConvention = "$sitid-aks",
 *                         ProductName = "AKSarc",
 *                     },
 *                 },
 *                 TemplateName = "base",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devhub/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devhub.NewIacProfile(ctx, "iacProfile", &devhub.IacProfileArgs{
 * 			IacProfileName:       pulumi.String("profile1"),
 * 			Location:             pulumi.String("location1"),
 * 			RepositoryMainBranch: pulumi.String("main"),
 * 			RepositoryName:       pulumi.String("localtest"),
 * 			RepositoryOwner:      pulumi.String("owner"),
 * 			ResourceGroupName:    pulumi.String("resourceGroup1"),
 * 			Stages: devhub.StagePropertiesArray{
 * 				&devhub.StagePropertiesArgs{
 * 					Dependencies:   pulumi.StringArray{},
 * 					GitEnvironment: pulumi.String("Terraform"),
 * 					StageName:      pulumi.String("dev"),
 * 				},
 * 				&devhub.StagePropertiesArgs{
 * 					Dependencies: pulumi.StringArray{
 * 						pulumi.String("dev"),
 * 					},
 * 					GitEnvironment: pulumi.String("Terraform"),
 * 					StageName:      pulumi.String("qa"),
 * 				},
 * 				&devhub.StagePropertiesArgs{
 * 					Dependencies: pulumi.StringArray{
 * 						pulumi.String("qa"),
 * 					},
 * 					GitEnvironment: pulumi.String("Terraform"),
 * 					StageName:      pulumi.String("prod"),
 * 				},
 * 			},
 * 			StorageAccountName:          pulumi.String("hybridiac"),
 * 			StorageAccountResourceGroup: pulumi.String("hybrid-iac"),
 * 			StorageAccountSubscription:  pulumi.String("subscription"),
 * 			StorageContainerName:        pulumi.String("hybridiac"),
 * 			Tags: pulumi.StringMap{
 * 				"appname": pulumi.String("testApp"),
 * 			},
 * 			Templates: devhub.IacTemplatePropertiesArray{
 * 				&devhub.IacTemplatePropertiesArgs{
 * 					InstanceName:     pulumi.String("contoso"),
 * 					InstanceStage:    pulumi.String("dev"),
 * 					SourceResourceId: pulumi.String("/subscriptions/xxxx/resourceGroups/xxxx"),
 * 					TemplateDetails: devhub.IacTemplateDetailsArray{
 * 						&devhub.IacTemplateDetailsArgs{
 * 							Count:            pulumi.Int(1),
 * 							NamingConvention: pulumi.String("$sitid-hci"),
 * 							ProductName:      pulumi.String("HCI"),
 * 						},
 * 						&devhub.IacTemplateDetailsArgs{
 * 							Count:            pulumi.Int(1),
 * 							NamingConvention: pulumi.String("$sitid-aks"),
 * 							ProductName:      pulumi.String("AKSarc"),
 * 						},
 * 					},
 * 					TemplateName: pulumi.String("base"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devhub.IacProfile;
 * import com.pulumi.azurenative.devhub.IacProfileArgs;
 * import com.pulumi.azurenative.devhub.inputs.StagePropertiesArgs;
 * import com.pulumi.azurenative.devhub.inputs.IacTemplatePropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var iacProfile = new IacProfile("iacProfile", IacProfileArgs.builder()
 *             .iacProfileName("profile1")
 *             .location("location1")
 *             .repositoryMainBranch("main")
 *             .repositoryName("localtest")
 *             .repositoryOwner("owner")
 *             .resourceGroupName("resourceGroup1")
 *             .stages(
 *                 StagePropertiesArgs.builder()
 *                     .dependencies()
 *                     .gitEnvironment("Terraform")
 *                     .stageName("dev")
 *                     .build(),
 *                 StagePropertiesArgs.builder()
 *                     .dependencies("dev")
 *                     .gitEnvironment("Terraform")
 *                     .stageName("qa")
 *                     .build(),
 *                 StagePropertiesArgs.builder()
 *                     .dependencies("qa")
 *                     .gitEnvironment("Terraform")
 *                     .stageName("prod")
 *                     .build())
 *             .storageAccountName("hybridiac")
 *             .storageAccountResourceGroup("hybrid-iac")
 *             .storageAccountSubscription("subscription")
 *             .storageContainerName("hybridiac")
 *             .tags(Map.of("appname", "testApp"))
 *             .templates(IacTemplatePropertiesArgs.builder()
 *                 .instanceName("contoso")
 *                 .instanceStage("dev")
 *                 .sourceResourceId("/subscriptions/xxxx/resourceGroups/xxxx")
 *                 .templateDetails(
 *                     IacTemplateDetailsArgs.builder()
 *                         .count(1)
 *                         .namingConvention("$sitid-hci")
 *                         .productName("HCI")
 *                         .build(),
 *                     IacTemplateDetailsArgs.builder()
 *                         .count(1)
 *                         .namingConvention("$sitid-aks")
 *                         .productName("AKSarc")
 *                         .build())
 *                 .templateName("base")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devhub:IacProfile profile1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevHub/iacProfiles/{iacProfileName}
 * ```
 * @property branchName Repository Branch Name
 * @property iacProfileName The name of the IacProfile.
 * @property location The geo-location where the resource lives
 * @property repositoryMainBranch Repository Main Branch
 * @property repositoryName Repository Name
 * @property repositoryOwner Repository Owner
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property stages
 * @property storageAccountName Terraform Storage Account Name
 * @property storageAccountResourceGroup Terraform Storage Account Resource Group
 * @property storageAccountSubscription Terraform Storage Account Subscription
 * @property storageContainerName Terraform Container Name
 * @property tags Resource tags.
 * @property templates
 */
public data class IacProfileArgs(
    public val branchName: Output<String>? = null,
    public val iacProfileName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val repositoryMainBranch: Output<String>? = null,
    public val repositoryName: Output<String>? = null,
    public val repositoryOwner: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val stages: Output<List<StagePropertiesArgs>>? = null,
    public val storageAccountName: Output<String>? = null,
    public val storageAccountResourceGroup: Output<String>? = null,
    public val storageAccountSubscription: Output<String>? = null,
    public val storageContainerName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val templates: Output<List<IacTemplatePropertiesArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devhub.IacProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.devhub.IacProfileArgs =
        com.pulumi.azurenative.devhub.IacProfileArgs.builder()
            .branchName(branchName?.applyValue({ args0 -> args0 }))
            .iacProfileName(iacProfileName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .repositoryMainBranch(repositoryMainBranch?.applyValue({ args0 -> args0 }))
            .repositoryName(repositoryName?.applyValue({ args0 -> args0 }))
            .repositoryOwner(repositoryOwner?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .stages(stages?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .storageAccountName(storageAccountName?.applyValue({ args0 -> args0 }))
            .storageAccountResourceGroup(storageAccountResourceGroup?.applyValue({ args0 -> args0 }))
            .storageAccountSubscription(storageAccountSubscription?.applyValue({ args0 -> args0 }))
            .storageContainerName(storageContainerName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .templates(
                templates?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [IacProfileArgs].
 */
@PulumiTagMarker
public class IacProfileArgsBuilder internal constructor() {
    private var branchName: Output<String>? = null

    private var iacProfileName: Output<String>? = null

    private var location: Output<String>? = null

    private var repositoryMainBranch: Output<String>? = null

    private var repositoryName: Output<String>? = null

    private var repositoryOwner: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var stages: Output<List<StagePropertiesArgs>>? = null

    private var storageAccountName: Output<String>? = null

    private var storageAccountResourceGroup: Output<String>? = null

    private var storageAccountSubscription: Output<String>? = null

    private var storageContainerName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var templates: Output<List<IacTemplatePropertiesArgs>>? = null

    /**
     * @param value Repository Branch Name
     */
    @JvmName("dojhidjiofbrvvel")
    public suspend fun branchName(`value`: Output<String>) {
        this.branchName = value
    }

    /**
     * @param value The name of the IacProfile.
     */
    @JvmName("dvrjfthaamklpgxv")
    public suspend fun iacProfileName(`value`: Output<String>) {
        this.iacProfileName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("vihsuqtdnbwymswm")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Repository Main Branch
     */
    @JvmName("qpmaymvtqobtmsyb")
    public suspend fun repositoryMainBranch(`value`: Output<String>) {
        this.repositoryMainBranch = value
    }

    /**
     * @param value Repository Name
     */
    @JvmName("vfvpgssjlfpxgvfp")
    public suspend fun repositoryName(`value`: Output<String>) {
        this.repositoryName = value
    }

    /**
     * @param value Repository Owner
     */
    @JvmName("kqlpbaibhbxyrdkn")
    public suspend fun repositoryOwner(`value`: Output<String>) {
        this.repositoryOwner = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xsuvdysmptvogdpk")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value
     */
    @JvmName("fkrxixpjvuuwjrjj")
    public suspend fun stages(`value`: Output<List<StagePropertiesArgs>>) {
        this.stages = value
    }

    @JvmName("bvadpcuuwpimwbnt")
    public suspend fun stages(vararg values: Output<StagePropertiesArgs>) {
        this.stages = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("heecjrucwxyvfbba")
    public suspend fun stages(values: List<Output<StagePropertiesArgs>>) {
        this.stages = Output.all(values)
    }

    /**
     * @param value Terraform Storage Account Name
     */
    @JvmName("iuaygrbotewvncwu")
    public suspend fun storageAccountName(`value`: Output<String>) {
        this.storageAccountName = value
    }

    /**
     * @param value Terraform Storage Account Resource Group
     */
    @JvmName("ltgncqkalxlseqog")
    public suspend fun storageAccountResourceGroup(`value`: Output<String>) {
        this.storageAccountResourceGroup = value
    }

    /**
     * @param value Terraform Storage Account Subscription
     */
    @JvmName("qmqxheqoqsgkgrfo")
    public suspend fun storageAccountSubscription(`value`: Output<String>) {
        this.storageAccountSubscription = value
    }

    /**
     * @param value Terraform Container Name
     */
    @JvmName("nreoxxikdwxnjhdy")
    public suspend fun storageContainerName(`value`: Output<String>) {
        this.storageContainerName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("xxjkkmjycjpdfetj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("vydouyoywrnkkumm")
    public suspend fun templates(`value`: Output<List<IacTemplatePropertiesArgs>>) {
        this.templates = value
    }

    @JvmName("iwawremklslkecgp")
    public suspend fun templates(vararg values: Output<IacTemplatePropertiesArgs>) {
        this.templates = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("mhlyiljtaunsbaii")
    public suspend fun templates(values: List<Output<IacTemplatePropertiesArgs>>) {
        this.templates = Output.all(values)
    }

    /**
     * @param value Repository Branch Name
     */
    @JvmName("uanemrsjocubbpnx")
    public suspend fun branchName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.branchName = mapped
    }

    /**
     * @param value The name of the IacProfile.
     */
    @JvmName("ejtvcgkbbkamegmk")
    public suspend fun iacProfileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iacProfileName = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("cbnijxijaejedsem")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Repository Main Branch
     */
    @JvmName("gslgduolybeijtrf")
    public suspend fun repositoryMainBranch(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repositoryMainBranch = mapped
    }

    /**
     * @param value Repository Name
     */
    @JvmName("mtigdkevheshlyen")
    public suspend fun repositoryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repositoryName = mapped
    }

    /**
     * @param value Repository Owner
     */
    @JvmName("iiulfmjsiyhaydfu")
    public suspend fun repositoryOwner(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repositoryOwner = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("nsrkptsvehvqhyxb")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value
     */
    @JvmName("ratitwywsmvcqqbh")
    public suspend fun stages(`value`: List<StagePropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stages = mapped
    }

    /**
     * @param argument
     */
    @JvmName("mnovbgokdqbyugph")
    public suspend fun stages(argument: List<suspend StagePropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            StagePropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.stages = mapped
    }

    /**
     * @param argument
     */
    @JvmName("pkphpohouatnrrmt")
    public suspend fun stages(vararg argument: suspend StagePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            StagePropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.stages = mapped
    }

    /**
     * @param argument
     */
    @JvmName("edhuhpprqwrfkgef")
    public suspend fun stages(argument: suspend StagePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(StagePropertiesArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.stages = mapped
    }

    /**
     * @param values
     */
    @JvmName("tfgwbesomcvksbct")
    public suspend fun stages(vararg values: StagePropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stages = mapped
    }

    /**
     * @param value Terraform Storage Account Name
     */
    @JvmName("cqiruoxfofprviwu")
    public suspend fun storageAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountName = mapped
    }

    /**
     * @param value Terraform Storage Account Resource Group
     */
    @JvmName("jsebqwctewnbilbo")
    public suspend fun storageAccountResourceGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountResourceGroup = mapped
    }

    /**
     * @param value Terraform Storage Account Subscription
     */
    @JvmName("udswdulfngmgiyfe")
    public suspend fun storageAccountSubscription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountSubscription = mapped
    }

    /**
     * @param value Terraform Container Name
     */
    @JvmName("qlemcqndxvmmkiap")
    public suspend fun storageContainerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageContainerName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("gihlkmrbujbcygat")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("lnlxoopgyjusiegv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value
     */
    @JvmName("gqnhysrajudfotlr")
    public suspend fun templates(`value`: List<IacTemplatePropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templates = mapped
    }

    /**
     * @param argument
     */
    @JvmName("nckkrfvxfjwgtyyw")
    public suspend fun templates(argument: List<suspend IacTemplatePropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            IacTemplatePropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.templates = mapped
    }

    /**
     * @param argument
     */
    @JvmName("culmrwovleobdpjv")
    public suspend fun templates(vararg argument: suspend IacTemplatePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            IacTemplatePropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.templates = mapped
    }

    /**
     * @param argument
     */
    @JvmName("efepduisscxdacls")
    public suspend fun templates(argument: suspend IacTemplatePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IacTemplatePropertiesArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.templates = mapped
    }

    /**
     * @param values
     */
    @JvmName("mlylnlpqikxvocta")
    public suspend fun templates(vararg values: IacTemplatePropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.templates = mapped
    }

    internal fun build(): IacProfileArgs = IacProfileArgs(
        branchName = branchName,
        iacProfileName = iacProfileName,
        location = location,
        repositoryMainBranch = repositoryMainBranch,
        repositoryName = repositoryName,
        repositoryOwner = repositoryOwner,
        resourceGroupName = resourceGroupName,
        stages = stages,
        storageAccountName = storageAccountName,
        storageAccountResourceGroup = storageAccountResourceGroup,
        storageAccountSubscription = storageAccountSubscription,
        storageContainerName = storageContainerName,
        tags = tags,
        templates = templates,
    )
}
