@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devhub.kotlin

import com.pulumi.azurenative.devhub.WorkflowArgs.builder
import com.pulumi.azurenative.devhub.kotlin.enums.DockerfileGenerationMode
import com.pulumi.azurenative.devhub.kotlin.enums.GenerationLanguage
import com.pulumi.azurenative.devhub.kotlin.enums.GenerationManifestType
import com.pulumi.azurenative.devhub.kotlin.enums.ManifestGenerationMode
import com.pulumi.azurenative.devhub.kotlin.inputs.ACRArgs
import com.pulumi.azurenative.devhub.kotlin.inputs.ACRArgsBuilder
import com.pulumi.azurenative.devhub.kotlin.inputs.DeploymentPropertiesArgs
import com.pulumi.azurenative.devhub.kotlin.inputs.DeploymentPropertiesArgsBuilder
import com.pulumi.azurenative.devhub.kotlin.inputs.GitHubWorkflowProfileOidcCredentialsArgs
import com.pulumi.azurenative.devhub.kotlin.inputs.GitHubWorkflowProfileOidcCredentialsArgsBuilder
import com.pulumi.azurenative.devhub.kotlin.inputs.WorkflowRunArgs
import com.pulumi.azurenative.devhub.kotlin.inputs.WorkflowRunArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource representation of a workflow
 * Azure REST API version: 2022-10-11-preview. Prior API version in Azure Native 1.x: 2022-04-01-preview.
 * Other available API versions: 2023-08-01, 2024-05-01-preview.
 * ## Example Usage
 * ### Create Workflow
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workflow = new AzureNative.DevHub.Workflow("workflow", new()
 *     {
 *         Acr = new AzureNative.DevHub.Inputs.ACRArgs
 *         {
 *             AcrRegistryName = "registry1",
 *             AcrRepositoryName = "repo1",
 *             AcrResourceGroup = "resourceGroup1",
 *             AcrSubscriptionId = "subscriptionId1",
 *         },
 *         AksResourceId = "/subscriptions/subscriptionId1/resourcegroups/resourceGroup1/providers/Microsoft.ContainerService/managedClusters/cluster1",
 *         BranchName = "branch1",
 *         DeploymentProperties = new AzureNative.DevHub.Inputs.DeploymentPropertiesArgs
 *         {
 *             KubeManifestLocations = new[]
 *             {
 *                 "/src/manifests/",
 *             },
 *             ManifestType = AzureNative.DevHub.ManifestType.Kube,
 *             Overrides =
 *             {
 *                 { "key1", "value1" },
 *             },
 *         },
 *         DockerBuildContext = "repo1/src/",
 *         Dockerfile = "repo1/images/Dockerfile",
 *         Location = "location1",
 *         Namespace = "namespace1",
 *         OidcCredentials = new AzureNative.DevHub.Inputs.GitHubWorkflowProfileOidcCredentialsArgs
 *         {
 *             AzureClientId = "12345678-3456-7890-5678-012345678901",
 *             AzureTenantId = "66666666-3456-7890-5678-012345678901",
 *         },
 *         RepositoryName = "repo1",
 *         RepositoryOwner = "owner1",
 *         ResourceGroupName = "resourceGroup1",
 *         Tags =
 *         {
 *             { "appname", "testApp" },
 *         },
 *         WorkflowName = "workflow1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devhub/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devhub.NewWorkflow(ctx, "workflow", &devhub.WorkflowArgs{
 * 			Acr: &devhub.ACRArgs{
 * 				AcrRegistryName:   pulumi.String("registry1"),
 * 				AcrRepositoryName: pulumi.String("repo1"),
 * 				AcrResourceGroup:  pulumi.String("resourceGroup1"),
 * 				AcrSubscriptionId: pulumi.String("subscriptionId1"),
 * 			},
 * 			AksResourceId: pulumi.String("/subscriptions/subscriptionId1/resourcegroups/resourceGroup1/providers/Microsoft.ContainerService/managedClusters/cluster1"),
 * 			BranchName:    pulumi.String("branch1"),
 * 			DeploymentProperties: &devhub.DeploymentPropertiesArgs{
 * 				KubeManifestLocations: pulumi.StringArray{
 * 					pulumi.String("/src/manifests/"),
 * 				},
 * 				ManifestType: pulumi.String(devhub.ManifestTypeKube),
 * 				Overrides: pulumi.StringMap{
 * 					"key1": pulumi.String("value1"),
 * 				},
 * 			},
 * 			DockerBuildContext: pulumi.String("repo1/src/"),
 * 			Dockerfile:         pulumi.String("repo1/images/Dockerfile"),
 * 			Location:           pulumi.String("location1"),
 * 			Namespace:          pulumi.String("namespace1"),
 * 			OidcCredentials: &devhub.GitHubWorkflowProfileOidcCredentialsArgs{
 * 				AzureClientId: pulumi.String("12345678-3456-7890-5678-012345678901"),
 * 				AzureTenantId: pulumi.String("66666666-3456-7890-5678-012345678901"),
 * 			},
 * 			RepositoryName:    pulumi.String("repo1"),
 * 			RepositoryOwner:   pulumi.String("owner1"),
 * 			ResourceGroupName: pulumi.String("resourceGroup1"),
 * 			Tags: pulumi.StringMap{
 * 				"appname": pulumi.String("testApp"),
 * 			},
 * 			WorkflowName: pulumi.String("workflow1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devhub.Workflow;
 * import com.pulumi.azurenative.devhub.WorkflowArgs;
 * import com.pulumi.azurenative.devhub.inputs.ACRArgs;
 * import com.pulumi.azurenative.devhub.inputs.DeploymentPropertiesArgs;
 * import com.pulumi.azurenative.devhub.inputs.GitHubWorkflowProfileOidcCredentialsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workflow = new Workflow("workflow", WorkflowArgs.builder()
 *             .acr(ACRArgs.builder()
 *                 .acrRegistryName("registry1")
 *                 .acrRepositoryName("repo1")
 *                 .acrResourceGroup("resourceGroup1")
 *                 .acrSubscriptionId("subscriptionId1")
 *                 .build())
 *             .aksResourceId("/subscriptions/subscriptionId1/resourcegroups/resourceGroup1/providers/Microsoft.ContainerService/managedClusters/cluster1")
 *             .branchName("branch1")
 *             .deploymentProperties(DeploymentPropertiesArgs.builder()
 *                 .kubeManifestLocations("/src/manifests/")
 *                 .manifestType("kube")
 *                 .overrides(Map.of("key1", "value1"))
 *                 .build())
 *             .dockerBuildContext("repo1/src/")
 *             .dockerfile("repo1/images/Dockerfile")
 *             .location("location1")
 *             .namespace("namespace1")
 *             .oidcCredentials(GitHubWorkflowProfileOidcCredentialsArgs.builder()
 *                 .azureClientId("12345678-3456-7890-5678-012345678901")
 *                 .azureTenantId("66666666-3456-7890-5678-012345678901")
 *                 .build())
 *             .repositoryName("repo1")
 *             .repositoryOwner("owner1")
 *             .resourceGroupName("resourceGroup1")
 *             .tags(Map.of("appname", "testApp"))
 *             .workflowName("workflow1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create Workflow With Artifact Generation
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workflow = new AzureNative.DevHub.Workflow("workflow", new()
 *     {
 *         Acr = new AzureNative.DevHub.Inputs.ACRArgs
 *         {
 *             AcrRegistryName = "registry1",
 *             AcrRepositoryName = "repo1",
 *             AcrResourceGroup = "resourceGroup1",
 *             AcrSubscriptionId = "subscriptionId1",
 *         },
 *         AksResourceId = "/subscriptions/subscriptionId1/resourcegroups/resourceGroup1/providers/Microsoft.ContainerService/managedClusters/cluster1",
 *         AppName = "my-app",
 *         BranchName = "branch1",
 *         DeploymentProperties = new AzureNative.DevHub.Inputs.DeploymentPropertiesArgs
 *         {
 *             KubeManifestLocations = new[]
 *             {
 *                 "/src/manifests/",
 *             },
 *             ManifestType = AzureNative.DevHub.ManifestType.Kube,
 *             Overrides =
 *             {
 *                 { "key1", "value1" },
 *             },
 *         },
 *         DockerBuildContext = "repo1/src/",
 *         Dockerfile = "repo1/images/Dockerfile",
 *         DockerfileGenerationMode = AzureNative.DevHub.DockerfileGenerationMode.Enabled,
 *         DockerfileOutputDirectory = "./",
 *         GenerationLanguage = AzureNative.DevHub.GenerationLanguage.Javascript,
 *         ImageName = "myimage",
 *         ImageTag = "latest",
 *         LanguageVersion = "14",
 *         Location = "location1",
 *         ManifestGenerationMode = AzureNative.DevHub.ManifestGenerationMode.Enabled,
 *         ManifestOutputDirectory = "./",
 *         ManifestType = AzureNative.DevHub.GenerationManifestType.Kube,
 *         OidcCredentials = new AzureNative.DevHub.Inputs.GitHubWorkflowProfileOidcCredentialsArgs
 *         {
 *             AzureClientId = "12345678-3456-7890-5678-012345678901",
 *             AzureTenantId = "66666666-3456-7890-5678-012345678901",
 *         },
 *         Port = "80",
 *         RepositoryName = "repo1",
 *         RepositoryOwner = "owner1",
 *         ResourceGroupName = "resourceGroup1",
 *         Tags =
 *         {
 *             { "appname", "testApp" },
 *         },
 *         WorkflowName = "workflow1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devhub/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devhub.NewWorkflow(ctx, "workflow", &devhub.WorkflowArgs{
 * 			Acr: &devhub.ACRArgs{
 * 				AcrRegistryName:   pulumi.String("registry1"),
 * 				AcrRepositoryName: pulumi.String("repo1"),
 * 				AcrResourceGroup:  pulumi.String("resourceGroup1"),
 * 				AcrSubscriptionId: pulumi.String("subscriptionId1"),
 * 			},
 * 			AksResourceId: pulumi.String("/subscriptions/subscriptionId1/resourcegroups/resourceGroup1/providers/Microsoft.ContainerService/managedClusters/cluster1"),
 * 			AppName:       pulumi.String("my-app"),
 * 			BranchName:    pulumi.String("branch1"),
 * 			DeploymentProperties: &devhub.DeploymentPropertiesArgs{
 * 				KubeManifestLocations: pulumi.StringArray{
 * 					pulumi.String("/src/manifests/"),
 * 				},
 * 				ManifestType: pulumi.String(devhub.ManifestTypeKube),
 * 				Overrides: pulumi.StringMap{
 * 					"key1": pulumi.String("value1"),
 * 				},
 * 			},
 * 			DockerBuildContext:        pulumi.String("repo1/src/"),
 * 			Dockerfile:                pulumi.String("repo1/images/Dockerfile"),
 * 			DockerfileGenerationMode:  pulumi.String(devhub.DockerfileGenerationModeEnabled),
 * 			DockerfileOutputDirectory: pulumi.String("./"),
 * 			GenerationLanguage:        pulumi.String(devhub.GenerationLanguageJavascript),
 * 			ImageName:                 pulumi.String("myimage"),
 * 			ImageTag:                  pulumi.String("latest"),
 * 			LanguageVersion:           pulumi.String("14"),
 * 			Location:                  pulumi.String("location1"),
 * 			ManifestGenerationMode:    pulumi.String(devhub.ManifestGenerationModeEnabled),
 * 			ManifestOutputDirectory:   pulumi.String("./"),
 * 			ManifestType:              pulumi.String(devhub.GenerationManifestTypeKube),
 * 			OidcCredentials: &devhub.GitHubWorkflowProfileOidcCredentialsArgs{
 * 				AzureClientId: pulumi.String("12345678-3456-7890-5678-012345678901"),
 * 				AzureTenantId: pulumi.String("66666666-3456-7890-5678-012345678901"),
 * 			},
 * 			Port:              pulumi.String("80"),
 * 			RepositoryName:    pulumi.String("repo1"),
 * 			RepositoryOwner:   pulumi.String("owner1"),
 * 			ResourceGroupName: pulumi.String("resourceGroup1"),
 * 			Tags: pulumi.StringMap{
 * 				"appname": pulumi.String("testApp"),
 * 			},
 * 			WorkflowName: pulumi.String("workflow1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devhub.Workflow;
 * import com.pulumi.azurenative.devhub.WorkflowArgs;
 * import com.pulumi.azurenative.devhub.inputs.ACRArgs;
 * import com.pulumi.azurenative.devhub.inputs.DeploymentPropertiesArgs;
 * import com.pulumi.azurenative.devhub.inputs.GitHubWorkflowProfileOidcCredentialsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workflow = new Workflow("workflow", WorkflowArgs.builder()
 *             .acr(ACRArgs.builder()
 *                 .acrRegistryName("registry1")
 *                 .acrRepositoryName("repo1")
 *                 .acrResourceGroup("resourceGroup1")
 *                 .acrSubscriptionId("subscriptionId1")
 *                 .build())
 *             .aksResourceId("/subscriptions/subscriptionId1/resourcegroups/resourceGroup1/providers/Microsoft.ContainerService/managedClusters/cluster1")
 *             .appName("my-app")
 *             .branchName("branch1")
 *             .deploymentProperties(DeploymentPropertiesArgs.builder()
 *                 .kubeManifestLocations("/src/manifests/")
 *                 .manifestType("kube")
 *                 .overrides(Map.of("key1", "value1"))
 *                 .build())
 *             .dockerBuildContext("repo1/src/")
 *             .dockerfile("repo1/images/Dockerfile")
 *             .dockerfileGenerationMode("enabled")
 *             .dockerfileOutputDirectory("./")
 *             .generationLanguage("javascript")
 *             .imageName("myimage")
 *             .imageTag("latest")
 *             .languageVersion("14")
 *             .location("location1")
 *             .manifestGenerationMode("enabled")
 *             .manifestOutputDirectory("./")
 *             .manifestType("kube")
 *             .oidcCredentials(GitHubWorkflowProfileOidcCredentialsArgs.builder()
 *                 .azureClientId("12345678-3456-7890-5678-012345678901")
 *                 .azureTenantId("66666666-3456-7890-5678-012345678901")
 *                 .build())
 *             .port("80")
 *             .repositoryName("repo1")
 *             .repositoryOwner("owner1")
 *             .resourceGroupName("resourceGroup1")
 *             .tags(Map.of("appname", "testApp"))
 *             .workflowName("workflow1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devhub:Workflow workflow1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevHub/workflows/{workflowName}
 * ```
 * @property acr Information on the azure container registry
 * @property aksResourceId The Azure Kubernetes Cluster Resource the application will be deployed to.
 * @property appName The name of the app.
 * @property branchName Repository Branch Name
 * @property builderVersion The version of the language image used for building the code in the generated dockerfile.
 * @property deploymentProperties
 * @property dockerBuildContext Path to Dockerfile Build Context within the repository.
 * @property dockerfile Path to the Dockerfile within the repository.
 * @property dockerfileGenerationMode The mode of generation to be used for generating Dockerfiles.
 * @property dockerfileOutputDirectory The directory to output the generated Dockerfile to.
 * @property generationLanguage The programming language used.
 * @property imageName The name of the image to be generated.
 * @property imageTag The tag to apply to the generated image.
 * @property languageVersion The version of the language image used for execution in the generated dockerfile.
 * @property lastWorkflowRun
 * @property location The geo-location where the resource lives
 * @property manifestGenerationMode The mode of generation to be used for generating Manifest.
 * @property manifestOutputDirectory The directory to output the generated manifests to.
 * @property manifestType Determines the type of manifests to be generated.
 * @property namespace Kubernetes namespace the application is deployed to.
 * @property oidcCredentials The fields needed for OIDC with GitHub.
 * @property port The port the application is exposed on.
 * @property repositoryName Repository Name
 * @property repositoryOwner Repository Owner
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 * @property workflowName The name of the workflow resource.
 */
public data class WorkflowArgs(
    public val acr: Output<ACRArgs>? = null,
    public val aksResourceId: Output<String>? = null,
    public val appName: Output<String>? = null,
    public val branchName: Output<String>? = null,
    public val builderVersion: Output<String>? = null,
    public val deploymentProperties: Output<DeploymentPropertiesArgs>? = null,
    public val dockerBuildContext: Output<String>? = null,
    public val dockerfile: Output<String>? = null,
    public val dockerfileGenerationMode: Output<Either<String, DockerfileGenerationMode>>? = null,
    public val dockerfileOutputDirectory: Output<String>? = null,
    public val generationLanguage: Output<Either<String, GenerationLanguage>>? = null,
    public val imageName: Output<String>? = null,
    public val imageTag: Output<String>? = null,
    public val languageVersion: Output<String>? = null,
    public val lastWorkflowRun: Output<WorkflowRunArgs>? = null,
    public val location: Output<String>? = null,
    public val manifestGenerationMode: Output<Either<String, ManifestGenerationMode>>? = null,
    public val manifestOutputDirectory: Output<String>? = null,
    public val manifestType: Output<Either<String, GenerationManifestType>>? = null,
    public val namespace: Output<String>? = null,
    public val oidcCredentials: Output<GitHubWorkflowProfileOidcCredentialsArgs>? = null,
    public val port: Output<String>? = null,
    public val repositoryName: Output<String>? = null,
    public val repositoryOwner: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val workflowName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devhub.WorkflowArgs> {
    override fun toJava(): com.pulumi.azurenative.devhub.WorkflowArgs =
        com.pulumi.azurenative.devhub.WorkflowArgs.builder()
            .acr(acr?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .aksResourceId(aksResourceId?.applyValue({ args0 -> args0 }))
            .appName(appName?.applyValue({ args0 -> args0 }))
            .branchName(branchName?.applyValue({ args0 -> args0 }))
            .builderVersion(builderVersion?.applyValue({ args0 -> args0 }))
            .deploymentProperties(
                deploymentProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .dockerBuildContext(dockerBuildContext?.applyValue({ args0 -> args0 }))
            .dockerfile(dockerfile?.applyValue({ args0 -> args0 }))
            .dockerfileGenerationMode(
                dockerfileGenerationMode?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .dockerfileOutputDirectory(dockerfileOutputDirectory?.applyValue({ args0 -> args0 }))
            .generationLanguage(
                generationLanguage?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .imageName(imageName?.applyValue({ args0 -> args0 }))
            .imageTag(imageTag?.applyValue({ args0 -> args0 }))
            .languageVersion(languageVersion?.applyValue({ args0 -> args0 }))
            .lastWorkflowRun(lastWorkflowRun?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .manifestGenerationMode(
                manifestGenerationMode?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .manifestOutputDirectory(manifestOutputDirectory?.applyValue({ args0 -> args0 }))
            .manifestType(
                manifestType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .namespace(namespace?.applyValue({ args0 -> args0 }))
            .oidcCredentials(oidcCredentials?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .port(port?.applyValue({ args0 -> args0 }))
            .repositoryName(repositoryName?.applyValue({ args0 -> args0 }))
            .repositoryOwner(repositoryOwner?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .workflowName(workflowName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkflowArgs].
 */
@PulumiTagMarker
public class WorkflowArgsBuilder internal constructor() {
    private var acr: Output<ACRArgs>? = null

    private var aksResourceId: Output<String>? = null

    private var appName: Output<String>? = null

    private var branchName: Output<String>? = null

    private var builderVersion: Output<String>? = null

    private var deploymentProperties: Output<DeploymentPropertiesArgs>? = null

    private var dockerBuildContext: Output<String>? = null

    private var dockerfile: Output<String>? = null

    private var dockerfileGenerationMode: Output<Either<String, DockerfileGenerationMode>>? = null

    private var dockerfileOutputDirectory: Output<String>? = null

    private var generationLanguage: Output<Either<String, GenerationLanguage>>? = null

    private var imageName: Output<String>? = null

    private var imageTag: Output<String>? = null

    private var languageVersion: Output<String>? = null

    private var lastWorkflowRun: Output<WorkflowRunArgs>? = null

    private var location: Output<String>? = null

    private var manifestGenerationMode: Output<Either<String, ManifestGenerationMode>>? = null

    private var manifestOutputDirectory: Output<String>? = null

    private var manifestType: Output<Either<String, GenerationManifestType>>? = null

    private var namespace: Output<String>? = null

    private var oidcCredentials: Output<GitHubWorkflowProfileOidcCredentialsArgs>? = null

    private var port: Output<String>? = null

    private var repositoryName: Output<String>? = null

    private var repositoryOwner: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var workflowName: Output<String>? = null

    /**
     * @param value Information on the azure container registry
     */
    @JvmName("wfidfhpuubpdrjay")
    public suspend fun acr(`value`: Output<ACRArgs>) {
        this.acr = value
    }

    /**
     * @param value The Azure Kubernetes Cluster Resource the application will be deployed to.
     */
    @JvmName("vuacdfnpmguovcas")
    public suspend fun aksResourceId(`value`: Output<String>) {
        this.aksResourceId = value
    }

    /**
     * @param value The name of the app.
     */
    @JvmName("ubfjkcmbtblosnls")
    public suspend fun appName(`value`: Output<String>) {
        this.appName = value
    }

    /**
     * @param value Repository Branch Name
     */
    @JvmName("sdyvfhcgxpntmvmo")
    public suspend fun branchName(`value`: Output<String>) {
        this.branchName = value
    }

    /**
     * @param value The version of the language image used for building the code in the generated dockerfile.
     */
    @JvmName("urtpffrejaopeiit")
    public suspend fun builderVersion(`value`: Output<String>) {
        this.builderVersion = value
    }

    /**
     * @param value
     */
    @JvmName("hvdqtebubwoiahmt")
    public suspend fun deploymentProperties(`value`: Output<DeploymentPropertiesArgs>) {
        this.deploymentProperties = value
    }

    /**
     * @param value Path to Dockerfile Build Context within the repository.
     */
    @JvmName("nthslnkkxehasnmr")
    public suspend fun dockerBuildContext(`value`: Output<String>) {
        this.dockerBuildContext = value
    }

    /**
     * @param value Path to the Dockerfile within the repository.
     */
    @JvmName("mxmwwjlcuygvbqfa")
    public suspend fun dockerfile(`value`: Output<String>) {
        this.dockerfile = value
    }

    /**
     * @param value The mode of generation to be used for generating Dockerfiles.
     */
    @JvmName("hafadusirqqikobr")
    public suspend fun dockerfileGenerationMode(`value`: Output<Either<String, DockerfileGenerationMode>>) {
        this.dockerfileGenerationMode = value
    }

    /**
     * @param value The directory to output the generated Dockerfile to.
     */
    @JvmName("kkhgkschhkfjfjtd")
    public suspend fun dockerfileOutputDirectory(`value`: Output<String>) {
        this.dockerfileOutputDirectory = value
    }

    /**
     * @param value The programming language used.
     */
    @JvmName("lwrfxbhhubtepjhe")
    public suspend fun generationLanguage(`value`: Output<Either<String, GenerationLanguage>>) {
        this.generationLanguage = value
    }

    /**
     * @param value The name of the image to be generated.
     */
    @JvmName("kqvwetmlrjskxqpx")
    public suspend fun imageName(`value`: Output<String>) {
        this.imageName = value
    }

    /**
     * @param value The tag to apply to the generated image.
     */
    @JvmName("hvwuiyrklbpbwpfn")
    public suspend fun imageTag(`value`: Output<String>) {
        this.imageTag = value
    }

    /**
     * @param value The version of the language image used for execution in the generated dockerfile.
     */
    @JvmName("rrjkjtwahhjdgikt")
    public suspend fun languageVersion(`value`: Output<String>) {
        this.languageVersion = value
    }

    /**
     * @param value
     */
    @JvmName("xfmdpyojlksjvlvn")
    public suspend fun lastWorkflowRun(`value`: Output<WorkflowRunArgs>) {
        this.lastWorkflowRun = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("mvfubfjfeapslipj")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The mode of generation to be used for generating Manifest.
     */
    @JvmName("yocjrrbfbxhvepim")
    public suspend fun manifestGenerationMode(`value`: Output<Either<String, ManifestGenerationMode>>) {
        this.manifestGenerationMode = value
    }

    /**
     * @param value The directory to output the generated manifests to.
     */
    @JvmName("htfivetywofykvyo")
    public suspend fun manifestOutputDirectory(`value`: Output<String>) {
        this.manifestOutputDirectory = value
    }

    /**
     * @param value Determines the type of manifests to be generated.
     */
    @JvmName("jitoiawbmnibuasb")
    public suspend fun manifestType(`value`: Output<Either<String, GenerationManifestType>>) {
        this.manifestType = value
    }

    /**
     * @param value Kubernetes namespace the application is deployed to.
     */
    @JvmName("moflgmmvrqyllhad")
    public suspend fun namespace(`value`: Output<String>) {
        this.namespace = value
    }

    /**
     * @param value The fields needed for OIDC with GitHub.
     */
    @JvmName("bwdtsvahrivxsube")
    public suspend fun oidcCredentials(`value`: Output<GitHubWorkflowProfileOidcCredentialsArgs>) {
        this.oidcCredentials = value
    }

    /**
     * @param value The port the application is exposed on.
     */
    @JvmName("denqlswhnkjeapxo")
    public suspend fun port(`value`: Output<String>) {
        this.port = value
    }

    /**
     * @param value Repository Name
     */
    @JvmName("ljbyiwwypofabjiu")
    public suspend fun repositoryName(`value`: Output<String>) {
        this.repositoryName = value
    }

    /**
     * @param value Repository Owner
     */
    @JvmName("fxkffxkgftyxfmhv")
    public suspend fun repositoryOwner(`value`: Output<String>) {
        this.repositoryOwner = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("iqvatkjnpicuoiwi")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("qvvvptgxbvxdtaho")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the workflow resource.
     */
    @JvmName("kkimsuytliakmbwr")
    public suspend fun workflowName(`value`: Output<String>) {
        this.workflowName = value
    }

    /**
     * @param value Information on the azure container registry
     */
    @JvmName("fbxpgowvgugxbgcu")
    public suspend fun acr(`value`: ACRArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acr = mapped
    }

    /**
     * @param argument Information on the azure container registry
     */
    @JvmName("yepueqoharpmhbef")
    public suspend fun acr(argument: suspend ACRArgsBuilder.() -> Unit) {
        val toBeMapped = ACRArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.acr = mapped
    }

    /**
     * @param value The Azure Kubernetes Cluster Resource the application will be deployed to.
     */
    @JvmName("aqijisthussfigkv")
    public suspend fun aksResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aksResourceId = mapped
    }

    /**
     * @param value The name of the app.
     */
    @JvmName("vvbwmiuqjxfnrqwr")
    public suspend fun appName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appName = mapped
    }

    /**
     * @param value Repository Branch Name
     */
    @JvmName("jprcicwonmpxopkb")
    public suspend fun branchName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.branchName = mapped
    }

    /**
     * @param value The version of the language image used for building the code in the generated dockerfile.
     */
    @JvmName("rolmcksqywdjidio")
    public suspend fun builderVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.builderVersion = mapped
    }

    /**
     * @param value
     */
    @JvmName("tsmghuqblkkjjwsl")
    public suspend fun deploymentProperties(`value`: DeploymentPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentProperties = mapped
    }

    /**
     * @param argument
     */
    @JvmName("tdqwbrycopfqpbfi")
    public suspend fun deploymentProperties(argument: suspend DeploymentPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = DeploymentPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.deploymentProperties = mapped
    }

    /**
     * @param value Path to Dockerfile Build Context within the repository.
     */
    @JvmName("glidjhacojaolskh")
    public suspend fun dockerBuildContext(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dockerBuildContext = mapped
    }

    /**
     * @param value Path to the Dockerfile within the repository.
     */
    @JvmName("cxpnjgsrfwvntnmj")
    public suspend fun dockerfile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dockerfile = mapped
    }

    /**
     * @param value The mode of generation to be used for generating Dockerfiles.
     */
    @JvmName("pfjhrqisgaqrceqj")
    public suspend fun dockerfileGenerationMode(`value`: Either<String, DockerfileGenerationMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dockerfileGenerationMode = mapped
    }

    /**
     * @param value The mode of generation to be used for generating Dockerfiles.
     */
    @JvmName("eysmdhjxufejttlt")
    public fun dockerfileGenerationMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DockerfileGenerationMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dockerfileGenerationMode = mapped
    }

    /**
     * @param value The mode of generation to be used for generating Dockerfiles.
     */
    @JvmName("vjjhjaefursbpygm")
    public fun dockerfileGenerationMode(`value`: DockerfileGenerationMode) {
        val toBeMapped = Either.ofRight<String, DockerfileGenerationMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dockerfileGenerationMode = mapped
    }

    /**
     * @param value The directory to output the generated Dockerfile to.
     */
    @JvmName("owypinlylmefdfar")
    public suspend fun dockerfileOutputDirectory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dockerfileOutputDirectory = mapped
    }

    /**
     * @param value The programming language used.
     */
    @JvmName("bankycvoheusxcjm")
    public suspend fun generationLanguage(`value`: Either<String, GenerationLanguage>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.generationLanguage = mapped
    }

    /**
     * @param value The programming language used.
     */
    @JvmName("orialghyedfykmin")
    public fun generationLanguage(`value`: String) {
        val toBeMapped = Either.ofLeft<String, GenerationLanguage>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.generationLanguage = mapped
    }

    /**
     * @param value The programming language used.
     */
    @JvmName("ncpeecryxooakuuq")
    public fun generationLanguage(`value`: GenerationLanguage) {
        val toBeMapped = Either.ofRight<String, GenerationLanguage>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.generationLanguage = mapped
    }

    /**
     * @param value The name of the image to be generated.
     */
    @JvmName("rwkxgjykdxucyaus")
    public suspend fun imageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageName = mapped
    }

    /**
     * @param value The tag to apply to the generated image.
     */
    @JvmName("ewbddgjplgbxnvoq")
    public suspend fun imageTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageTag = mapped
    }

    /**
     * @param value The version of the language image used for execution in the generated dockerfile.
     */
    @JvmName("qtvoqqiojpqfpryd")
    public suspend fun languageVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.languageVersion = mapped
    }

    /**
     * @param value
     */
    @JvmName("jnisfwylkwulphja")
    public suspend fun lastWorkflowRun(`value`: WorkflowRunArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastWorkflowRun = mapped
    }

    /**
     * @param argument
     */
    @JvmName("answcyobjfhyuokj")
    public suspend fun lastWorkflowRun(argument: suspend WorkflowRunArgsBuilder.() -> Unit) {
        val toBeMapped = WorkflowRunArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.lastWorkflowRun = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("affissbvogdggbwm")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The mode of generation to be used for generating Manifest.
     */
    @JvmName("etwsldbmtjojmris")
    public suspend fun manifestGenerationMode(`value`: Either<String, ManifestGenerationMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.manifestGenerationMode = mapped
    }

    /**
     * @param value The mode of generation to be used for generating Manifest.
     */
    @JvmName("wfimksfttcaxhdrj")
    public fun manifestGenerationMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ManifestGenerationMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.manifestGenerationMode = mapped
    }

    /**
     * @param value The mode of generation to be used for generating Manifest.
     */
    @JvmName("pwtubumvwubmsmom")
    public fun manifestGenerationMode(`value`: ManifestGenerationMode) {
        val toBeMapped = Either.ofRight<String, ManifestGenerationMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.manifestGenerationMode = mapped
    }

    /**
     * @param value The directory to output the generated manifests to.
     */
    @JvmName("fuoktxrqphvkdhrd")
    public suspend fun manifestOutputDirectory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.manifestOutputDirectory = mapped
    }

    /**
     * @param value Determines the type of manifests to be generated.
     */
    @JvmName("xnpcbfpivjnbgjqx")
    public suspend fun manifestType(`value`: Either<String, GenerationManifestType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.manifestType = mapped
    }

    /**
     * @param value Determines the type of manifests to be generated.
     */
    @JvmName("tdmnqavuwabtsxqm")
    public fun manifestType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, GenerationManifestType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.manifestType = mapped
    }

    /**
     * @param value Determines the type of manifests to be generated.
     */
    @JvmName("jisrueitsujvpxhj")
    public fun manifestType(`value`: GenerationManifestType) {
        val toBeMapped = Either.ofRight<String, GenerationManifestType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.manifestType = mapped
    }

    /**
     * @param value Kubernetes namespace the application is deployed to.
     */
    @JvmName("iwmrpfxnsaadhgbw")
    public suspend fun namespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespace = mapped
    }

    /**
     * @param value The fields needed for OIDC with GitHub.
     */
    @JvmName("lkrqnwbvnrnjlbpn")
    public suspend fun oidcCredentials(`value`: GitHubWorkflowProfileOidcCredentialsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oidcCredentials = mapped
    }

    /**
     * @param argument The fields needed for OIDC with GitHub.
     */
    @JvmName("qpxphhfxpnbixgly")
    public suspend fun oidcCredentials(argument: suspend GitHubWorkflowProfileOidcCredentialsArgsBuilder.() -> Unit) {
        val toBeMapped = GitHubWorkflowProfileOidcCredentialsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.oidcCredentials = mapped
    }

    /**
     * @param value The port the application is exposed on.
     */
    @JvmName("tvalsoekhgmlvdjp")
    public suspend fun port(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value Repository Name
     */
    @JvmName("pxhsmtsyxwratuee")
    public suspend fun repositoryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repositoryName = mapped
    }

    /**
     * @param value Repository Owner
     */
    @JvmName("jnmfeixcptmkapki")
    public suspend fun repositoryOwner(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repositoryOwner = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cwsxojcltmkkavkv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("rrbmprfocmlhkmwm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("xunpsvdytfampvco")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of the workflow resource.
     */
    @JvmName("bdlxgvmobvhygdtw")
    public suspend fun workflowName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workflowName = mapped
    }

    internal fun build(): WorkflowArgs = WorkflowArgs(
        acr = acr,
        aksResourceId = aksResourceId,
        appName = appName,
        branchName = branchName,
        builderVersion = builderVersion,
        deploymentProperties = deploymentProperties,
        dockerBuildContext = dockerBuildContext,
        dockerfile = dockerfile,
        dockerfileGenerationMode = dockerfileGenerationMode,
        dockerfileOutputDirectory = dockerfileOutputDirectory,
        generationLanguage = generationLanguage,
        imageName = imageName,
        imageTag = imageTag,
        languageVersion = languageVersion,
        lastWorkflowRun = lastWorkflowRun,
        location = location,
        manifestGenerationMode = manifestGenerationMode,
        manifestOutputDirectory = manifestOutputDirectory,
        manifestType = manifestType,
        namespace = namespace,
        oidcCredentials = oidcCredentials,
        port = port,
        repositoryName = repositoryName,
        repositoryOwner = repositoryOwner,
        resourceGroupName = resourceGroupName,
        tags = tags,
        workflowName = workflowName,
    )
}
