@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devhub.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The mode of generation to be used for generating Dockerfiles.
 */
public enum class DockerfileGenerationMode(
    public val javaValue: com.pulumi.azurenative.devhub.enums.DockerfileGenerationMode,
) : ConvertibleToJava<com.pulumi.azurenative.devhub.enums.DockerfileGenerationMode> {
    /**
     * Dockerfiles will be generated
     */
    Enabled(com.pulumi.azurenative.devhub.enums.DockerfileGenerationMode.Enabled),

    /**
     * Dockerfiles will not be generated
     */
    Disabled(com.pulumi.azurenative.devhub.enums.DockerfileGenerationMode.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.devhub.enums.DockerfileGenerationMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devhub.enums.DockerfileGenerationMode): DockerfileGenerationMode =
            DockerfileGenerationMode.values().first { it.javaValue == javaType }
    }
}
