@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devhub.kotlin.inputs

import com.pulumi.azurenative.devhub.inputs.GetIacProfilePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property iacProfileName The name of the IacProfile.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetIacProfilePlainArgs(
    public val iacProfileName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.devhub.inputs.GetIacProfilePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.devhub.inputs.GetIacProfilePlainArgs =
        com.pulumi.azurenative.devhub.inputs.GetIacProfilePlainArgs.builder()
            .iacProfileName(iacProfileName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetIacProfilePlainArgs].
 */
@PulumiTagMarker
public class GetIacProfilePlainArgsBuilder internal constructor() {
    private var iacProfileName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the IacProfile.
     */
    @JvmName("yoafpbfuxdiecylv")
    public suspend fun iacProfileName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.iacProfileName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lshkyfjlksvvwunc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetIacProfilePlainArgs = GetIacProfilePlainArgs(
        iacProfileName = iacProfileName ?: throw PulumiNullFieldException("iacProfileName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
