@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devhub.kotlin.inputs

import com.pulumi.azurenative.devhub.inputs.IacTemplateDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property count Count of the product
 * @property namingConvention Naming convention of this product
 * @property productName The name of the products.
 */
public data class IacTemplateDetailsArgs(
    public val count: Output<Int>? = null,
    public val namingConvention: Output<String>? = null,
    public val productName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devhub.inputs.IacTemplateDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.devhub.inputs.IacTemplateDetailsArgs =
        com.pulumi.azurenative.devhub.inputs.IacTemplateDetailsArgs.builder()
            .count(count?.applyValue({ args0 -> args0 }))
            .namingConvention(namingConvention?.applyValue({ args0 -> args0 }))
            .productName(productName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IacTemplateDetailsArgs].
 */
@PulumiTagMarker
public class IacTemplateDetailsArgsBuilder internal constructor() {
    private var count: Output<Int>? = null

    private var namingConvention: Output<String>? = null

    private var productName: Output<String>? = null

    /**
     * @param value Count of the product
     */
    @JvmName("vdrnuniogcrxmtkw")
    public suspend fun count(`value`: Output<Int>) {
        this.count = value
    }

    /**
     * @param value Naming convention of this product
     */
    @JvmName("cbwybcioxdxqqttf")
    public suspend fun namingConvention(`value`: Output<String>) {
        this.namingConvention = value
    }

    /**
     * @param value The name of the products.
     */
    @JvmName("nymrkvuxetxmedid")
    public suspend fun productName(`value`: Output<String>) {
        this.productName = value
    }

    /**
     * @param value Count of the product
     */
    @JvmName("gaihpvhpqmqaerkd")
    public suspend fun count(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.count = mapped
    }

    /**
     * @param value Naming convention of this product
     */
    @JvmName("bofcjwqhydttsiqb")
    public suspend fun namingConvention(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namingConvention = mapped
    }

    /**
     * @param value The name of the products.
     */
    @JvmName("gpbejyjvmyvdasvm")
    public suspend fun productName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.productName = mapped
    }

    internal fun build(): IacTemplateDetailsArgs = IacTemplateDetailsArgs(
        count = count,
        namingConvention = namingConvention,
        productName = productName,
    )
}
