@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devhub.kotlin.inputs

import com.pulumi.azurenative.devhub.inputs.IacTemplatePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Properties of a IacTemplate.
 * @property instanceName the sample instance name of the template
 * @property instanceStage the source stage of the template
 * @property sourceResourceId the source store of the template
 * @property templateDetails
 * @property templateName Template Name
 */
public data class IacTemplatePropertiesArgs(
    public val instanceName: Output<String>? = null,
    public val instanceStage: Output<String>? = null,
    public val sourceResourceId: Output<String>? = null,
    public val templateDetails: Output<List<IacTemplateDetailsArgs>>? = null,
    public val templateName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devhub.inputs.IacTemplatePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.devhub.inputs.IacTemplatePropertiesArgs =
        com.pulumi.azurenative.devhub.inputs.IacTemplatePropertiesArgs.builder()
            .instanceName(instanceName?.applyValue({ args0 -> args0 }))
            .instanceStage(instanceStage?.applyValue({ args0 -> args0 }))
            .sourceResourceId(sourceResourceId?.applyValue({ args0 -> args0 }))
            .templateDetails(
                templateDetails?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .templateName(templateName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IacTemplatePropertiesArgs].
 */
@PulumiTagMarker
public class IacTemplatePropertiesArgsBuilder internal constructor() {
    private var instanceName: Output<String>? = null

    private var instanceStage: Output<String>? = null

    private var sourceResourceId: Output<String>? = null

    private var templateDetails: Output<List<IacTemplateDetailsArgs>>? = null

    private var templateName: Output<String>? = null

    /**
     * @param value the sample instance name of the template
     */
    @JvmName("ltdisboclnhvqgvo")
    public suspend fun instanceName(`value`: Output<String>) {
        this.instanceName = value
    }

    /**
     * @param value the source stage of the template
     */
    @JvmName("brvxekgvkvajxruf")
    public suspend fun instanceStage(`value`: Output<String>) {
        this.instanceStage = value
    }

    /**
     * @param value the source store of the template
     */
    @JvmName("xvuekbdrrupaimal")
    public suspend fun sourceResourceId(`value`: Output<String>) {
        this.sourceResourceId = value
    }

    /**
     * @param value
     */
    @JvmName("qxpsgablkioygpkh")
    public suspend fun templateDetails(`value`: Output<List<IacTemplateDetailsArgs>>) {
        this.templateDetails = value
    }

    @JvmName("mooclejkvotfdvyv")
    public suspend fun templateDetails(vararg values: Output<IacTemplateDetailsArgs>) {
        this.templateDetails = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("wtachomxylgvkkst")
    public suspend fun templateDetails(values: List<Output<IacTemplateDetailsArgs>>) {
        this.templateDetails = Output.all(values)
    }

    /**
     * @param value Template Name
     */
    @JvmName("scteakjrlvdqxacc")
    public suspend fun templateName(`value`: Output<String>) {
        this.templateName = value
    }

    /**
     * @param value the sample instance name of the template
     */
    @JvmName("kyagflmaspedhqbr")
    public suspend fun instanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceName = mapped
    }

    /**
     * @param value the source stage of the template
     */
    @JvmName("kjkbkbqcbybtuvio")
    public suspend fun instanceStage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceStage = mapped
    }

    /**
     * @param value the source store of the template
     */
    @JvmName("ncukhvbufofmwvpa")
    public suspend fun sourceResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceResourceId = mapped
    }

    /**
     * @param value
     */
    @JvmName("pfaljtfhemabkddh")
    public suspend fun templateDetails(`value`: List<IacTemplateDetailsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateDetails = mapped
    }

    /**
     * @param argument
     */
    @JvmName("qftvaaobeoddeyul")
    public suspend fun templateDetails(argument: List<suspend IacTemplateDetailsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            IacTemplateDetailsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.templateDetails = mapped
    }

    /**
     * @param argument
     */
    @JvmName("nyjnttbwyphlefvy")
    public suspend fun templateDetails(vararg argument: suspend IacTemplateDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            IacTemplateDetailsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.templateDetails = mapped
    }

    /**
     * @param argument
     */
    @JvmName("uyyawjbvklfowvsq")
    public suspend fun templateDetails(argument: suspend IacTemplateDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IacTemplateDetailsArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.templateDetails = mapped
    }

    /**
     * @param values
     */
    @JvmName("nrtrcesjmqogmhxw")
    public suspend fun templateDetails(vararg values: IacTemplateDetailsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.templateDetails = mapped
    }

    /**
     * @param value Template Name
     */
    @JvmName("ayxeooceitrapbkm")
    public suspend fun templateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateName = mapped
    }

    internal fun build(): IacTemplatePropertiesArgs = IacTemplatePropertiesArgs(
        instanceName = instanceName,
        instanceStage = instanceStage,
        sourceResourceId = sourceResourceId,
        templateDetails = templateDetails,
        templateName = templateName,
    )
}
