@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devhub.kotlin.inputs

import com.pulumi.azurenative.devhub.inputs.StagePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Properties of a Stage.
 * @property dependencies
 * @property gitEnvironment
 * @property stageName Stage Name
 */
public data class StagePropertiesArgs(
    public val dependencies: Output<List<String>>? = null,
    public val gitEnvironment: Output<String>? = null,
    public val stageName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devhub.inputs.StagePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.devhub.inputs.StagePropertiesArgs =
        com.pulumi.azurenative.devhub.inputs.StagePropertiesArgs.builder()
            .dependencies(dependencies?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .gitEnvironment(gitEnvironment?.applyValue({ args0 -> args0 }))
            .stageName(stageName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StagePropertiesArgs].
 */
@PulumiTagMarker
public class StagePropertiesArgsBuilder internal constructor() {
    private var dependencies: Output<List<String>>? = null

    private var gitEnvironment: Output<String>? = null

    private var stageName: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("qwfwygristnsnigk")
    public suspend fun dependencies(`value`: Output<List<String>>) {
        this.dependencies = value
    }

    @JvmName("ybspijxdyvqorvxt")
    public suspend fun dependencies(vararg values: Output<String>) {
        this.dependencies = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("ncykxysnhsihqvan")
    public suspend fun dependencies(values: List<Output<String>>) {
        this.dependencies = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("cnpcfvqkxrkgffll")
    public suspend fun gitEnvironment(`value`: Output<String>) {
        this.gitEnvironment = value
    }

    /**
     * @param value Stage Name
     */
    @JvmName("meflfasgstdixnmx")
    public suspend fun stageName(`value`: Output<String>) {
        this.stageName = value
    }

    /**
     * @param value
     */
    @JvmName("brlsmawunuplfuxj")
    public suspend fun dependencies(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dependencies = mapped
    }

    /**
     * @param values
     */
    @JvmName("bdvsioqkanneprxe")
    public suspend fun dependencies(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dependencies = mapped
    }

    /**
     * @param value
     */
    @JvmName("ecgpdhsjghmxdsbt")
    public suspend fun gitEnvironment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gitEnvironment = mapped
    }

    /**
     * @param value Stage Name
     */
    @JvmName("hvdwmjanoubivcqm")
    public suspend fun stageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stageName = mapped
    }

    internal fun build(): StagePropertiesArgs = StagePropertiesArgs(
        dependencies = dependencies,
        gitEnvironment = gitEnvironment,
        stageName = stageName,
    )
}
