@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devhub.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * URL used to authorize the Developer Hub GitHub App
 * @property authURL URL for authorizing the Developer Hub GitHub App
 * @property token OAuth token used to make calls to GitHub
 */
public data class GetGitHubOAuthResult(
    public val authURL: String? = null,
    public val token: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devhub.outputs.GetGitHubOAuthResult): GetGitHubOAuthResult = GetGitHubOAuthResult(
            authURL = javaType.authURL().map({ args0 -> args0 }).orElse(null),
            token = javaType.token().map({ args0 -> args0 }).orElse(null),
        )
    }
}
