@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devhub.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Resource representation of a IacProfile.
 * @property authStatus Determines the authorization status of requests.
 * @property branchName Repository Branch Name
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property prStatus The status of the Pull Request submitted against the users repository.
 * @property pullNumber The number associated with the submitted pull request.
 * @property repositoryMainBranch Repository Main Branch
 * @property repositoryName Repository Name
 * @property repositoryOwner Repository Owner
 * @property stages
 * @property storageAccountName Terraform Storage Account Name
 * @property storageAccountResourceGroup Terraform Storage Account Resource Group
 * @property storageAccountSubscription Terraform Storage Account Subscription
 * @property storageContainerName Terraform Container Name
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property templates
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetIacProfileResult(
    public val authStatus: String,
    public val branchName: String? = null,
    public val etag: String,
    public val id: String,
    public val location: String,
    public val name: String,
    public val prStatus: String,
    public val pullNumber: Int,
    public val repositoryMainBranch: String? = null,
    public val repositoryName: String? = null,
    public val repositoryOwner: String? = null,
    public val stages: List<StagePropertiesResponse>? = null,
    public val storageAccountName: String? = null,
    public val storageAccountResourceGroup: String? = null,
    public val storageAccountSubscription: String? = null,
    public val storageContainerName: String? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val templates: List<IacTemplatePropertiesResponse>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devhub.outputs.GetIacProfileResult): GetIacProfileResult = GetIacProfileResult(
            authStatus = javaType.authStatus(),
            branchName = javaType.branchName().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag(),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            prStatus = javaType.prStatus(),
            pullNumber = javaType.pullNumber(),
            repositoryMainBranch = javaType.repositoryMainBranch().map({ args0 -> args0 }).orElse(null),
            repositoryName = javaType.repositoryName().map({ args0 -> args0 }).orElse(null),
            repositoryOwner = javaType.repositoryOwner().map({ args0 -> args0 }).orElse(null),
            stages = javaType.stages().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devhub.kotlin.outputs.StagePropertiesResponse.Companion.toKotlin(args0)
                })
            }),
            storageAccountName = javaType.storageAccountName().map({ args0 -> args0 }).orElse(null),
            storageAccountResourceGroup = javaType.storageAccountResourceGroup().map({ args0 ->
                args0
            }).orElse(null),
            storageAccountSubscription = javaType.storageAccountSubscription().map({ args0 ->
                args0
            }).orElse(null),
            storageContainerName = javaType.storageContainerName().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.devhub.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            templates = javaType.templates().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devhub.kotlin.outputs.IacTemplatePropertiesResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
        )
    }
}
