@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devhub.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Resource representation of a workflow
 * @property acr Information on the azure container registry
 * @property aksResourceId The Azure Kubernetes Cluster Resource the application will be deployed to.
 * @property appName The name of the app.
 * @property authStatus Determines the authorization status of requests.
 * @property branchName Repository Branch Name
 * @property builderVersion The version of the language image used for building the code in the generated dockerfile.
 * @property deploymentProperties
 * @property dockerBuildContext Path to Dockerfile Build Context within the repository.
 * @property dockerfile Path to the Dockerfile within the repository.
 * @property dockerfileGenerationMode The mode of generation to be used for generating Dockerfiles.
 * @property dockerfileOutputDirectory The directory to output the generated Dockerfile to.
 * @property generationLanguage The programming language used.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property imageName The name of the image to be generated.
 * @property imageTag The tag to apply to the generated image.
 * @property languageVersion The version of the language image used for execution in the generated dockerfile.
 * @property lastWorkflowRun
 * @property location The geo-location where the resource lives
 * @property manifestGenerationMode The mode of generation to be used for generating Manifest.
 * @property manifestOutputDirectory The directory to output the generated manifests to.
 * @property manifestType Determines the type of manifests to be generated.
 * @property name The name of the resource
 * @property namespace Kubernetes namespace the application is deployed to.
 * @property oidcCredentials The fields needed for OIDC with GitHub.
 * @property port The port the application is exposed on.
 * @property prStatus The status of the Pull Request submitted against the users repository.
 * @property prURL The URL to the Pull Request submitted against the users repository.
 * @property pullNumber The number associated with the submitted pull request.
 * @property repositoryName Repository Name
 * @property repositoryOwner Repository Owner
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetWorkflowResult(
    public val acr: ACRResponse? = null,
    public val aksResourceId: String? = null,
    public val appName: String? = null,
    public val authStatus: String,
    public val branchName: String? = null,
    public val builderVersion: String? = null,
    public val deploymentProperties: DeploymentPropertiesResponse? = null,
    public val dockerBuildContext: String? = null,
    public val dockerfile: String? = null,
    public val dockerfileGenerationMode: String? = null,
    public val dockerfileOutputDirectory: String? = null,
    public val generationLanguage: String? = null,
    public val id: String,
    public val imageName: String? = null,
    public val imageTag: String? = null,
    public val languageVersion: String? = null,
    public val lastWorkflowRun: WorkflowRunResponse? = null,
    public val location: String,
    public val manifestGenerationMode: String? = null,
    public val manifestOutputDirectory: String? = null,
    public val manifestType: String? = null,
    public val name: String,
    public val namespace: String? = null,
    public val oidcCredentials: GitHubWorkflowProfileResponseOidcCredentials? = null,
    public val port: String? = null,
    public val prStatus: String,
    public val prURL: String,
    public val pullNumber: Int,
    public val repositoryName: String? = null,
    public val repositoryOwner: String? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devhub.outputs.GetWorkflowResult): GetWorkflowResult = GetWorkflowResult(
            acr = javaType.acr().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devhub.kotlin.outputs.ACRResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            aksResourceId = javaType.aksResourceId().map({ args0 -> args0 }).orElse(null),
            appName = javaType.appName().map({ args0 -> args0 }).orElse(null),
            authStatus = javaType.authStatus(),
            branchName = javaType.branchName().map({ args0 -> args0 }).orElse(null),
            builderVersion = javaType.builderVersion().map({ args0 -> args0 }).orElse(null),
            deploymentProperties = javaType.deploymentProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devhub.kotlin.outputs.DeploymentPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            dockerBuildContext = javaType.dockerBuildContext().map({ args0 -> args0 }).orElse(null),
            dockerfile = javaType.dockerfile().map({ args0 -> args0 }).orElse(null),
            dockerfileGenerationMode = javaType.dockerfileGenerationMode().map({ args0 -> args0 }).orElse(null),
            dockerfileOutputDirectory = javaType.dockerfileOutputDirectory().map({ args0 ->
                args0
            }).orElse(null),
            generationLanguage = javaType.generationLanguage().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            imageName = javaType.imageName().map({ args0 -> args0 }).orElse(null),
            imageTag = javaType.imageTag().map({ args0 -> args0 }).orElse(null),
            languageVersion = javaType.languageVersion().map({ args0 -> args0 }).orElse(null),
            lastWorkflowRun = javaType.lastWorkflowRun().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devhub.kotlin.outputs.WorkflowRunResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location(),
            manifestGenerationMode = javaType.manifestGenerationMode().map({ args0 -> args0 }).orElse(null),
            manifestOutputDirectory = javaType.manifestOutputDirectory().map({ args0 -> args0 }).orElse(null),
            manifestType = javaType.manifestType().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            namespace = javaType.namespace().map({ args0 -> args0 }).orElse(null),
            oidcCredentials = javaType.oidcCredentials().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devhub.kotlin.outputs.GitHubWorkflowProfileResponseOidcCredentials.Companion.toKotlin(args0)
                })
            }).orElse(null),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            prStatus = javaType.prStatus(),
            prURL = javaType.prURL(),
            pullNumber = javaType.pullNumber(),
            repositoryName = javaType.repositoryName().map({ args0 -> args0 }).orElse(null),
            repositoryOwner = javaType.repositoryOwner().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.devhub.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
