@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devhub.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property count Count of the product
 * @property namingConvention Naming convention of this product
 * @property productName The name of the products.
 */
public data class IacTemplateDetailsResponse(
    public val count: Int? = null,
    public val namingConvention: String? = null,
    public val productName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devhub.outputs.IacTemplateDetailsResponse): IacTemplateDetailsResponse = IacTemplateDetailsResponse(
            count = javaType.count().map({ args0 -> args0 }).orElse(null),
            namingConvention = javaType.namingConvention().map({ args0 -> args0 }).orElse(null),
            productName = javaType.productName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
