@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devhub.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Properties of a IacTemplate.
 * @property instanceName the sample instance name of the template
 * @property instanceStage the source stage of the template
 * @property quickStartTemplateType Determines the authorization status of requests.
 * @property sourceResourceId the source store of the template
 * @property templateDetails
 * @property templateName Template Name
 */
public data class IacTemplatePropertiesResponse(
    public val instanceName: String? = null,
    public val instanceStage: String? = null,
    public val quickStartTemplateType: String,
    public val sourceResourceId: String? = null,
    public val templateDetails: List<IacTemplateDetailsResponse>? = null,
    public val templateName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devhub.outputs.IacTemplatePropertiesResponse): IacTemplatePropertiesResponse = IacTemplatePropertiesResponse(
            instanceName = javaType.instanceName().map({ args0 -> args0 }).orElse(null),
            instanceStage = javaType.instanceStage().map({ args0 -> args0 }).orElse(null),
            quickStartTemplateType = javaType.quickStartTemplateType(),
            sourceResourceId = javaType.sourceResourceId().map({ args0 -> args0 }).orElse(null),
            templateDetails = javaType.templateDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devhub.kotlin.outputs.IacTemplateDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            templateName = javaType.templateName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
