@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devhub.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Properties of a Stage.
 * @property dependencies
 * @property gitEnvironment
 * @property stageName Stage Name
 */
public data class StagePropertiesResponse(
    public val dependencies: List<String>? = null,
    public val gitEnvironment: String? = null,
    public val stageName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devhub.outputs.StagePropertiesResponse): StagePropertiesResponse = StagePropertiesResponse(
            dependencies = javaType.dependencies().map({ args0 -> args0 }),
            gitEnvironment = javaType.gitEnvironment().map({ args0 -> args0 }).orElse(null),
            stageName = javaType.stageName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
