@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceregistry.kotlin

import com.pulumi.azurenative.deviceregistry.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.deviceregistry.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.deviceregistry.kotlin.outputs.TransportAuthenticationResponse
import com.pulumi.azurenative.deviceregistry.kotlin.outputs.UserAuthenticationResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.deviceregistry.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.deviceregistry.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.deviceregistry.kotlin.outputs.TransportAuthenticationResponse.Companion.toKotlin as transportAuthenticationResponseToKotlin
import com.pulumi.azurenative.deviceregistry.kotlin.outputs.UserAuthenticationResponse.Companion.toKotlin as userAuthenticationResponseToKotlin

/**
 * Builder for [AssetEndpointProfile].
 */
@PulumiTagMarker
public class AssetEndpointProfileResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AssetEndpointProfileArgs = AssetEndpointProfileArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AssetEndpointProfileArgsBuilder.() -> Unit) {
        val builder = AssetEndpointProfileArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AssetEndpointProfile {
        val builtJavaResource =
            com.pulumi.azurenative.deviceregistry.AssetEndpointProfile(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AssetEndpointProfile(builtJavaResource)
    }
}

/**
 * Asset Endpoint Profile definition.
 * Azure REST API version: 2023-11-01-preview.
 * ## Example Usage
 * ### Create_AssetEndpointProfile
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var assetEndpointProfile = new AzureNative.DeviceRegistry.AssetEndpointProfile("assetEndpointProfile", new()
 *     {
 *         AssetEndpointProfileName = "my-assetendpointprofile",
 *         ExtendedLocation = new AzureNative.DeviceRegistry.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.extendedlocation/customlocations/location1",
 *             Type = "CustomLocation",
 *         },
 *         Location = "West Europe",
 *         ResourceGroupName = "myResourceGroup",
 *         Tags =
 *         {
 *             { "site", "building-1" },
 *         },
 *         TargetAddress = "https://www.example.com/myTargetAddress",
 *         UserAuthentication = new AzureNative.DeviceRegistry.Inputs.UserAuthenticationArgs
 *         {
 *             Mode = AzureNative.DeviceRegistry.UserAuthenticationMode.Anonymous,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/deviceregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := deviceregistry.NewAssetEndpointProfile(ctx, "assetEndpointProfile", &deviceregistry.AssetEndpointProfileArgs{
 * 			AssetEndpointProfileName: pulumi.String("my-assetendpointprofile"),
 * 			ExtendedLocation: &deviceregistry.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.extendedlocation/customlocations/location1"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			Location:          pulumi.String("West Europe"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Tags: pulumi.StringMap{
 * 				"site": pulumi.String("building-1"),
 * 			},
 * 			TargetAddress: pulumi.String("https://www.example.com/myTargetAddress"),
 * 			UserAuthentication: &deviceregistry.UserAuthenticationArgs{
 * 				Mode: pulumi.String(deviceregistry.UserAuthenticationModeAnonymous),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.deviceregistry.AssetEndpointProfile;
 * import com.pulumi.azurenative.deviceregistry.AssetEndpointProfileArgs;
 * import com.pulumi.azurenative.deviceregistry.inputs.ExtendedLocationArgs;
 * import com.pulumi.azurenative.deviceregistry.inputs.UserAuthenticationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var assetEndpointProfile = new AssetEndpointProfile("assetEndpointProfile", AssetEndpointProfileArgs.builder()
 *             .assetEndpointProfileName("my-assetendpointprofile")
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.extendedlocation/customlocations/location1")
 *                 .type("CustomLocation")
 *                 .build())
 *             .location("West Europe")
 *             .resourceGroupName("myResourceGroup")
 *             .tags(Map.of("site", "building-1"))
 *             .targetAddress("https://www.example.com/myTargetAddress")
 *             .userAuthentication(UserAuthenticationArgs.builder()
 *                 .mode("Anonymous")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:deviceregistry:AssetEndpointProfile my-assetendpointprofile /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DeviceRegistry/assetEndpointProfiles/{assetEndpointProfileName}
 * ```
 */
public class AssetEndpointProfile internal constructor(
    override val javaResource: com.pulumi.azurenative.deviceregistry.AssetEndpointProfile,
) : KotlinCustomResource(javaResource, AssetEndpointProfileMapper) {
    /**
     * Contains connectivity type specific further configuration (e.g. OPC UA, Modbus, ONVIF).
     */
    public val additionalConfiguration: Output<String>?
        get() = javaResource.additionalConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The extended location.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.let({ args0 ->
                extendedLocationResponseToKotlin(args0)
            })
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The local valid URI specifying the network address/DNS name of a southbound device. The scheme part of the targetAddress URI specifies the type of the device. The additionalConfiguration field holds further connector type specific configuration.
     */
    public val targetAddress: Output<String>
        get() = javaResource.targetAddress().applyValue({ args0 -> args0 })

    /**
     * Defines the authentication mechanism for the southbound connector connecting to the shop floor/OT device.
     */
    public val transportAuthentication: Output<TransportAuthenticationResponse>?
        get() = javaResource.transportAuthentication().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> transportAuthenticationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Defines the client authentication mechanism to the server.
     */
    public val userAuthentication: Output<UserAuthenticationResponse>?
        get() = javaResource.userAuthentication().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> userAuthenticationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Globally unique, immutable, non-reusable id.
     */
    public val uuid: Output<String>
        get() = javaResource.uuid().applyValue({ args0 -> args0 })
}

public object AssetEndpointProfileMapper : ResourceMapper<AssetEndpointProfile> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.deviceregistry.AssetEndpointProfile::class == javaResource::class

    override fun map(javaResource: Resource): AssetEndpointProfile = AssetEndpointProfile(
        javaResource
            as com.pulumi.azurenative.deviceregistry.AssetEndpointProfile,
    )
}

/**
 * @see [AssetEndpointProfile].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AssetEndpointProfile].
 */
public suspend fun assetEndpointProfile(
    name: String,
    block: suspend AssetEndpointProfileResourceBuilder.() -> Unit,
): AssetEndpointProfile {
    val builder = AssetEndpointProfileResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AssetEndpointProfile].
 * @param name The _unique_ name of the resulting resource.
 */
public fun assetEndpointProfile(name: String): AssetEndpointProfile {
    val builder = AssetEndpointProfileResourceBuilder()
    builder.name(name)
    return builder.build()
}
