@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceregistry.kotlin

import com.pulumi.azurenative.deviceregistry.AssetEndpointProfileArgs.builder
import com.pulumi.azurenative.deviceregistry.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.deviceregistry.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.azurenative.deviceregistry.kotlin.inputs.TransportAuthenticationArgs
import com.pulumi.azurenative.deviceregistry.kotlin.inputs.TransportAuthenticationArgsBuilder
import com.pulumi.azurenative.deviceregistry.kotlin.inputs.UserAuthenticationArgs
import com.pulumi.azurenative.deviceregistry.kotlin.inputs.UserAuthenticationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Asset Endpoint Profile definition.
 * Azure REST API version: 2023-11-01-preview.
 * ## Example Usage
 * ### Create_AssetEndpointProfile
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var assetEndpointProfile = new AzureNative.DeviceRegistry.AssetEndpointProfile("assetEndpointProfile", new()
 *     {
 *         AssetEndpointProfileName = "my-assetendpointprofile",
 *         ExtendedLocation = new AzureNative.DeviceRegistry.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.extendedlocation/customlocations/location1",
 *             Type = "CustomLocation",
 *         },
 *         Location = "West Europe",
 *         ResourceGroupName = "myResourceGroup",
 *         Tags =
 *         {
 *             { "site", "building-1" },
 *         },
 *         TargetAddress = "https://www.example.com/myTargetAddress",
 *         UserAuthentication = new AzureNative.DeviceRegistry.Inputs.UserAuthenticationArgs
 *         {
 *             Mode = AzureNative.DeviceRegistry.UserAuthenticationMode.Anonymous,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/deviceregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := deviceregistry.NewAssetEndpointProfile(ctx, "assetEndpointProfile", &deviceregistry.AssetEndpointProfileArgs{
 * 			AssetEndpointProfileName: pulumi.String("my-assetendpointprofile"),
 * 			ExtendedLocation: &deviceregistry.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.extendedlocation/customlocations/location1"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			Location:          pulumi.String("West Europe"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Tags: pulumi.StringMap{
 * 				"site": pulumi.String("building-1"),
 * 			},
 * 			TargetAddress: pulumi.String("https://www.example.com/myTargetAddress"),
 * 			UserAuthentication: &deviceregistry.UserAuthenticationArgs{
 * 				Mode: pulumi.String(deviceregistry.UserAuthenticationModeAnonymous),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.deviceregistry.AssetEndpointProfile;
 * import com.pulumi.azurenative.deviceregistry.AssetEndpointProfileArgs;
 * import com.pulumi.azurenative.deviceregistry.inputs.ExtendedLocationArgs;
 * import com.pulumi.azurenative.deviceregistry.inputs.UserAuthenticationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var assetEndpointProfile = new AssetEndpointProfile("assetEndpointProfile", AssetEndpointProfileArgs.builder()
 *             .assetEndpointProfileName("my-assetendpointprofile")
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.extendedlocation/customlocations/location1")
 *                 .type("CustomLocation")
 *                 .build())
 *             .location("West Europe")
 *             .resourceGroupName("myResourceGroup")
 *             .tags(Map.of("site", "building-1"))
 *             .targetAddress("https://www.example.com/myTargetAddress")
 *             .userAuthentication(UserAuthenticationArgs.builder()
 *                 .mode("Anonymous")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:deviceregistry:AssetEndpointProfile my-assetendpointprofile /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DeviceRegistry/assetEndpointProfiles/{assetEndpointProfileName}
 * ```
 * @property additionalConfiguration Contains connectivity type specific further configuration (e.g. OPC UA, Modbus, ONVIF).
 * @property assetEndpointProfileName Asset Endpoint Profile name parameter.
 * @property extendedLocation The extended location.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 * @property targetAddress The local valid URI specifying the network address/DNS name of a southbound device. The scheme part of the targetAddress URI specifies the type of the device. The additionalConfiguration field holds further connector type specific configuration.
 * @property transportAuthentication Defines the authentication mechanism for the southbound connector connecting to the shop floor/OT device.
 * @property userAuthentication Defines the client authentication mechanism to the server.
 */
public data class AssetEndpointProfileArgs(
    public val additionalConfiguration: Output<String>? = null,
    public val assetEndpointProfileName: Output<String>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targetAddress: Output<String>? = null,
    public val transportAuthentication: Output<TransportAuthenticationArgs>? = null,
    public val userAuthentication: Output<UserAuthenticationArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.deviceregistry.AssetEndpointProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.deviceregistry.AssetEndpointProfileArgs =
        com.pulumi.azurenative.deviceregistry.AssetEndpointProfileArgs.builder()
            .additionalConfiguration(additionalConfiguration?.applyValue({ args0 -> args0 }))
            .assetEndpointProfileName(assetEndpointProfileName?.applyValue({ args0 -> args0 }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetAddress(targetAddress?.applyValue({ args0 -> args0 }))
            .transportAuthentication(
                transportAuthentication?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .userAuthentication(
                userAuthentication?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [AssetEndpointProfileArgs].
 */
@PulumiTagMarker
public class AssetEndpointProfileArgsBuilder internal constructor() {
    private var additionalConfiguration: Output<String>? = null

    private var assetEndpointProfileName: Output<String>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetAddress: Output<String>? = null

    private var transportAuthentication: Output<TransportAuthenticationArgs>? = null

    private var userAuthentication: Output<UserAuthenticationArgs>? = null

    /**
     * @param value Contains connectivity type specific further configuration (e.g. OPC UA, Modbus, ONVIF).
     */
    @JvmName("ifdsjcvbflgqqfmt")
    public suspend fun additionalConfiguration(`value`: Output<String>) {
        this.additionalConfiguration = value
    }

    /**
     * @param value Asset Endpoint Profile name parameter.
     */
    @JvmName("wmyctuugklxmwaxp")
    public suspend fun assetEndpointProfileName(`value`: Output<String>) {
        this.assetEndpointProfileName = value
    }

    /**
     * @param value The extended location.
     */
    @JvmName("olvggsuynwrjwixx")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("wcymixydcesydfvo")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gxilkeogsbyenirt")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("cjoxtasipxcbxega")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The local valid URI specifying the network address/DNS name of a southbound device. The scheme part of the targetAddress URI specifies the type of the device. The additionalConfiguration field holds further connector type specific configuration.
     */
    @JvmName("uruvkmhcvihamohd")
    public suspend fun targetAddress(`value`: Output<String>) {
        this.targetAddress = value
    }

    /**
     * @param value Defines the authentication mechanism for the southbound connector connecting to the shop floor/OT device.
     */
    @JvmName("pxdhokeffhkgovsp")
    public suspend fun transportAuthentication(`value`: Output<TransportAuthenticationArgs>) {
        this.transportAuthentication = value
    }

    /**
     * @param value Defines the client authentication mechanism to the server.
     */
    @JvmName("xqghycbxujdpbffd")
    public suspend fun userAuthentication(`value`: Output<UserAuthenticationArgs>) {
        this.userAuthentication = value
    }

    /**
     * @param value Contains connectivity type specific further configuration (e.g. OPC UA, Modbus, ONVIF).
     */
    @JvmName("kaxnmonhjekehaxk")
    public suspend fun additionalConfiguration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalConfiguration = mapped
    }

    /**
     * @param value Asset Endpoint Profile name parameter.
     */
    @JvmName("svihxtpsgqgfeuna")
    public suspend fun assetEndpointProfileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assetEndpointProfileName = mapped
    }

    /**
     * @param value The extended location.
     */
    @JvmName("obwacgovluvxtxjg")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extended location.
     */
    @JvmName("duxwqybwmmvfjxfv")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ukkwpkoxthfagwvn")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vslwaotscbqkpdyh")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("uypkrcopdetsdnjv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("fqksmtnxuddibood")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The local valid URI specifying the network address/DNS name of a southbound device. The scheme part of the targetAddress URI specifies the type of the device. The additionalConfiguration field holds further connector type specific configuration.
     */
    @JvmName("jrypwmkhkhssrrls")
    public suspend fun targetAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetAddress = mapped
    }

    /**
     * @param value Defines the authentication mechanism for the southbound connector connecting to the shop floor/OT device.
     */
    @JvmName("mnxvfkeduccoyskc")
    public suspend fun transportAuthentication(`value`: TransportAuthenticationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transportAuthentication = mapped
    }

    /**
     * @param argument Defines the authentication mechanism for the southbound connector connecting to the shop floor/OT device.
     */
    @JvmName("jwhaejqeehhuxvxo")
    public suspend fun transportAuthentication(argument: suspend TransportAuthenticationArgsBuilder.() -> Unit) {
        val toBeMapped = TransportAuthenticationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.transportAuthentication = mapped
    }

    /**
     * @param value Defines the client authentication mechanism to the server.
     */
    @JvmName("dqrcknjfocpyrnry")
    public suspend fun userAuthentication(`value`: UserAuthenticationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAuthentication = mapped
    }

    /**
     * @param argument Defines the client authentication mechanism to the server.
     */
    @JvmName("hfiuofhncnslkngp")
    public suspend fun userAuthentication(argument: suspend UserAuthenticationArgsBuilder.() -> Unit) {
        val toBeMapped = UserAuthenticationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.userAuthentication = mapped
    }

    internal fun build(): AssetEndpointProfileArgs = AssetEndpointProfileArgs(
        additionalConfiguration = additionalConfiguration,
        assetEndpointProfileName = assetEndpointProfileName,
        extendedLocation = extendedLocation,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
        targetAddress = targetAddress,
        transportAuthentication = transportAuthentication,
        userAuthentication = userAuthentication,
    )
}
