@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceregistry.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Defines the mode to authenticate the user of the client at the server.
 */
public enum class UserAuthenticationMode(
    public val javaValue: com.pulumi.azurenative.deviceregistry.enums.UserAuthenticationMode,
) : ConvertibleToJava<com.pulumi.azurenative.deviceregistry.enums.UserAuthenticationMode> {
    /**
     * The user authentication mode is anonymous.
     */
    Anonymous(com.pulumi.azurenative.deviceregistry.enums.UserAuthenticationMode.Anonymous),

    /**
     * The user authentication mode is an x509 certificate.
     */
    Certificate(com.pulumi.azurenative.deviceregistry.enums.UserAuthenticationMode.Certificate),

    /**
     * The user authentication mode is a username and password.
     */
    UsernamePassword(com.pulumi.azurenative.deviceregistry.enums.UserAuthenticationMode.UsernamePassword),
    ;

    override fun toJava(): com.pulumi.azurenative.deviceregistry.enums.UserAuthenticationMode =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.deviceregistry.enums.UserAuthenticationMode): UserAuthenticationMode = UserAuthenticationMode.values().first { it.javaValue == javaType }
    }
}
