@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceregistry.kotlin.inputs

import com.pulumi.azurenative.deviceregistry.inputs.DataPointArgs.builder
import com.pulumi.azurenative.deviceregistry.kotlin.enums.DataPointsObservabilityMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines the data point properties.
 * @property capabilityId The path to the type definition of the capability (e.g. DTMI, OPC UA information model node id, etc.), for example dtmi:com:example:Robot:_contents:__prop1;1.
 * @property dataPointConfiguration Protocol-specific configuration for the data point. For OPC UA, this could include configuration like, publishingInterval, samplingInterval, and queueSize.
 * @property dataSource The address of the source of the data in the asset (e.g. URL) so that a client can access the data source on the asset.
 * @property name The name of the data point.
 * @property observabilityMode An indication of how the data point should be mapped to OpenTelemetry.
 */
public data class DataPointArgs(
    public val capabilityId: Output<String>? = null,
    public val dataPointConfiguration: Output<String>? = null,
    public val dataSource: Output<String>,
    public val name: Output<String>? = null,
    public val observabilityMode: Output<Either<String, DataPointsObservabilityMode>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.deviceregistry.inputs.DataPointArgs> {
    override fun toJava(): com.pulumi.azurenative.deviceregistry.inputs.DataPointArgs =
        com.pulumi.azurenative.deviceregistry.inputs.DataPointArgs.builder()
            .capabilityId(capabilityId?.applyValue({ args0 -> args0 }))
            .dataPointConfiguration(dataPointConfiguration?.applyValue({ args0 -> args0 }))
            .dataSource(dataSource.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .observabilityMode(
                observabilityMode?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [DataPointArgs].
 */
@PulumiTagMarker
public class DataPointArgsBuilder internal constructor() {
    private var capabilityId: Output<String>? = null

    private var dataPointConfiguration: Output<String>? = null

    private var dataSource: Output<String>? = null

    private var name: Output<String>? = null

    private var observabilityMode: Output<Either<String, DataPointsObservabilityMode>>? = null

    /**
     * @param value The path to the type definition of the capability (e.g. DTMI, OPC UA information model node id, etc.), for example dtmi:com:example:Robot:_contents:__prop1;1.
     */
    @JvmName("rfdaqvjveriipefx")
    public suspend fun capabilityId(`value`: Output<String>) {
        this.capabilityId = value
    }

    /**
     * @param value Protocol-specific configuration for the data point. For OPC UA, this could include configuration like, publishingInterval, samplingInterval, and queueSize.
     */
    @JvmName("tsldugwenhuiiqhk")
    public suspend fun dataPointConfiguration(`value`: Output<String>) {
        this.dataPointConfiguration = value
    }

    /**
     * @param value The address of the source of the data in the asset (e.g. URL) so that a client can access the data source on the asset.
     */
    @JvmName("pmymyugwoappqjia")
    public suspend fun dataSource(`value`: Output<String>) {
        this.dataSource = value
    }

    /**
     * @param value The name of the data point.
     */
    @JvmName("fgglhjrcwrqchflf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value An indication of how the data point should be mapped to OpenTelemetry.
     */
    @JvmName("vgorfsfmvqjkjeey")
    public suspend fun observabilityMode(`value`: Output<Either<String, DataPointsObservabilityMode>>) {
        this.observabilityMode = value
    }

    /**
     * @param value The path to the type definition of the capability (e.g. DTMI, OPC UA information model node id, etc.), for example dtmi:com:example:Robot:_contents:__prop1;1.
     */
    @JvmName("hdtcnajiwhwqdble")
    public suspend fun capabilityId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capabilityId = mapped
    }

    /**
     * @param value Protocol-specific configuration for the data point. For OPC UA, this could include configuration like, publishingInterval, samplingInterval, and queueSize.
     */
    @JvmName("bjifnjyqalgkchqq")
    public suspend fun dataPointConfiguration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataPointConfiguration = mapped
    }

    /**
     * @param value The address of the source of the data in the asset (e.g. URL) so that a client can access the data source on the asset.
     */
    @JvmName("dmnjnruhyiljusiy")
    public suspend fun dataSource(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataSource = mapped
    }

    /**
     * @param value The name of the data point.
     */
    @JvmName("dnktbwlevptlfrhm")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value An indication of how the data point should be mapped to OpenTelemetry.
     */
    @JvmName("chshabdodgslwrkf")
    public suspend fun observabilityMode(`value`: Either<String, DataPointsObservabilityMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.observabilityMode = mapped
    }

    /**
     * @param value An indication of how the data point should be mapped to OpenTelemetry.
     */
    @JvmName("rdomeycrssitnrhj")
    public fun observabilityMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DataPointsObservabilityMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.observabilityMode = mapped
    }

    /**
     * @param value An indication of how the data point should be mapped to OpenTelemetry.
     */
    @JvmName("xpvxsdghucxdkcwv")
    public fun observabilityMode(`value`: DataPointsObservabilityMode) {
        val toBeMapped = Either.ofRight<String, DataPointsObservabilityMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.observabilityMode = mapped
    }

    internal fun build(): DataPointArgs = DataPointArgs(
        capabilityId = capabilityId,
        dataPointConfiguration = dataPointConfiguration,
        dataSource = dataSource ?: throw PulumiNullFieldException("dataSource"),
        name = name,
        observabilityMode = observabilityMode,
    )
}
