@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceregistry.kotlin.inputs

import com.pulumi.azurenative.deviceregistry.inputs.OwnCertificateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Certificate or private key that can be used by the southbound connector connecting to the shop floor/OT device. The accepted extensions are .der for certificates and .pfx/.pem for private keys.
 * @property certPasswordReference Secret Reference Name (Pfx or Pem password).
 * @property certSecretReference Secret Reference name (cert and private key).
 * @property certThumbprint Certificate thumbprint.
 */
public data class OwnCertificateArgs(
    public val certPasswordReference: Output<String>? = null,
    public val certSecretReference: Output<String>? = null,
    public val certThumbprint: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.deviceregistry.inputs.OwnCertificateArgs> {
    override fun toJava(): com.pulumi.azurenative.deviceregistry.inputs.OwnCertificateArgs =
        com.pulumi.azurenative.deviceregistry.inputs.OwnCertificateArgs.builder()
            .certPasswordReference(certPasswordReference?.applyValue({ args0 -> args0 }))
            .certSecretReference(certSecretReference?.applyValue({ args0 -> args0 }))
            .certThumbprint(certThumbprint?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OwnCertificateArgs].
 */
@PulumiTagMarker
public class OwnCertificateArgsBuilder internal constructor() {
    private var certPasswordReference: Output<String>? = null

    private var certSecretReference: Output<String>? = null

    private var certThumbprint: Output<String>? = null

    /**
     * @param value Secret Reference Name (Pfx or Pem password).
     */
    @JvmName("cnvvyldoqgrsbeou")
    public suspend fun certPasswordReference(`value`: Output<String>) {
        this.certPasswordReference = value
    }

    /**
     * @param value Secret Reference name (cert and private key).
     */
    @JvmName("psagjpergvtwkooo")
    public suspend fun certSecretReference(`value`: Output<String>) {
        this.certSecretReference = value
    }

    /**
     * @param value Certificate thumbprint.
     */
    @JvmName("cjatgulrmhlkieys")
    public suspend fun certThumbprint(`value`: Output<String>) {
        this.certThumbprint = value
    }

    /**
     * @param value Secret Reference Name (Pfx or Pem password).
     */
    @JvmName("dqtclgcodxsebhfa")
    public suspend fun certPasswordReference(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certPasswordReference = mapped
    }

    /**
     * @param value Secret Reference name (cert and private key).
     */
    @JvmName("rdmspmxxcqtrnabv")
    public suspend fun certSecretReference(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certSecretReference = mapped
    }

    /**
     * @param value Certificate thumbprint.
     */
    @JvmName("osexwoqyqblcchmm")
    public suspend fun certThumbprint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certThumbprint = mapped
    }

    internal fun build(): OwnCertificateArgs = OwnCertificateArgs(
        certPasswordReference = certPasswordReference,
        certSecretReference = certSecretReference,
        certThumbprint = certThumbprint,
    )
}
