@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceregistry.kotlin.inputs

import com.pulumi.azurenative.deviceregistry.inputs.TransportAuthenticationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Definition of the authentication mechanism for the southbound connector.
 * @property ownCertificates Defines a reference to a secret which contains all certificates and private keys that can be used by the southbound connector connecting to the shop floor/OT device. The accepted extensions are .der for certificates and .pfx/.pem for private keys.
 */
public data class TransportAuthenticationArgs(
    public val ownCertificates: Output<List<OwnCertificateArgs>>,
) : ConvertibleToJava<com.pulumi.azurenative.deviceregistry.inputs.TransportAuthenticationArgs> {
    override fun toJava(): com.pulumi.azurenative.deviceregistry.inputs.TransportAuthenticationArgs =
        com.pulumi.azurenative.deviceregistry.inputs.TransportAuthenticationArgs.builder()
            .ownCertificates(
                ownCertificates.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [TransportAuthenticationArgs].
 */
@PulumiTagMarker
public class TransportAuthenticationArgsBuilder internal constructor() {
    private var ownCertificates: Output<List<OwnCertificateArgs>>? = null

    /**
     * @param value Defines a reference to a secret which contains all certificates and private keys that can be used by the southbound connector connecting to the shop floor/OT device. The accepted extensions are .der for certificates and .pfx/.pem for private keys.
     */
    @JvmName("hfuqlphklxjfpkkd")
    public suspend fun ownCertificates(`value`: Output<List<OwnCertificateArgs>>) {
        this.ownCertificates = value
    }

    @JvmName("aqssbapujhsxxbrb")
    public suspend fun ownCertificates(vararg values: Output<OwnCertificateArgs>) {
        this.ownCertificates = Output.all(values.asList())
    }

    /**
     * @param values Defines a reference to a secret which contains all certificates and private keys that can be used by the southbound connector connecting to the shop floor/OT device. The accepted extensions are .der for certificates and .pfx/.pem for private keys.
     */
    @JvmName("phnciwjsocbljtdd")
    public suspend fun ownCertificates(values: List<Output<OwnCertificateArgs>>) {
        this.ownCertificates = Output.all(values)
    }

    /**
     * @param value Defines a reference to a secret which contains all certificates and private keys that can be used by the southbound connector connecting to the shop floor/OT device. The accepted extensions are .der for certificates and .pfx/.pem for private keys.
     */
    @JvmName("fklmllujmysjmcsj")
    public suspend fun ownCertificates(`value`: List<OwnCertificateArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ownCertificates = mapped
    }

    /**
     * @param argument Defines a reference to a secret which contains all certificates and private keys that can be used by the southbound connector connecting to the shop floor/OT device. The accepted extensions are .der for certificates and .pfx/.pem for private keys.
     */
    @JvmName("ghpcejqilmsdmibf")
    public suspend fun ownCertificates(argument: List<suspend OwnCertificateArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            OwnCertificateArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ownCertificates = mapped
    }

    /**
     * @param argument Defines a reference to a secret which contains all certificates and private keys that can be used by the southbound connector connecting to the shop floor/OT device. The accepted extensions are .der for certificates and .pfx/.pem for private keys.
     */
    @JvmName("hgrvwovlyvnoumrm")
    public suspend fun ownCertificates(vararg argument: suspend OwnCertificateArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            OwnCertificateArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ownCertificates = mapped
    }

    /**
     * @param argument Defines a reference to a secret which contains all certificates and private keys that can be used by the southbound connector connecting to the shop floor/OT device. The accepted extensions are .der for certificates and .pfx/.pem for private keys.
     */
    @JvmName("trmopbkcejwdbvru")
    public suspend fun ownCertificates(argument: suspend OwnCertificateArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(OwnCertificateArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ownCertificates = mapped
    }

    /**
     * @param values Defines a reference to a secret which contains all certificates and private keys that can be used by the southbound connector connecting to the shop floor/OT device. The accepted extensions are .der for certificates and .pfx/.pem for private keys.
     */
    @JvmName("knavlqxngqwoeafk")
    public suspend fun ownCertificates(vararg values: OwnCertificateArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ownCertificates = mapped
    }

    internal fun build(): TransportAuthenticationArgs = TransportAuthenticationArgs(
        ownCertificates = ownCertificates ?: throw PulumiNullFieldException("ownCertificates"),
    )
}
