@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceregistry.kotlin.inputs

import com.pulumi.azurenative.deviceregistry.inputs.X509CredentialsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The x509 certificate for authentication mode Certificate.
 * @property certificateReference A reference to secret containing the certificate and private key (e.g. stored as .der/.pem or .der/.pfx).
 */
public data class X509CredentialsArgs(
    public val certificateReference: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.deviceregistry.inputs.X509CredentialsArgs> {
    override fun toJava(): com.pulumi.azurenative.deviceregistry.inputs.X509CredentialsArgs =
        com.pulumi.azurenative.deviceregistry.inputs.X509CredentialsArgs.builder()
            .certificateReference(certificateReference.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [X509CredentialsArgs].
 */
@PulumiTagMarker
public class X509CredentialsArgsBuilder internal constructor() {
    private var certificateReference: Output<String>? = null

    /**
     * @param value A reference to secret containing the certificate and private key (e.g. stored as .der/.pem or .der/.pfx).
     */
    @JvmName("fefunpveglwywblc")
    public suspend fun certificateReference(`value`: Output<String>) {
        this.certificateReference = value
    }

    /**
     * @param value A reference to secret containing the certificate and private key (e.g. stored as .der/.pem or .der/.pfx).
     */
    @JvmName("arotftcentyuiksq")
    public suspend fun certificateReference(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.certificateReference = mapped
    }

    internal fun build(): X509CredentialsArgs = X509CredentialsArgs(
        certificateReference = certificateReference ?: throw
            PulumiNullFieldException("certificateReference"),
    )
}
