@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceregistry.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Defines the asset status error properties.
 * @property code Error code for classification of errors (ex: 400, 404, 500, etc.).
 * @property message Human readable helpful error message to provide additional context for error (ex: “capability Id 'foo' does not exist”).
 */
public data class AssetStatusErrorResponse(
    public val code: Int? = null,
    public val message: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.deviceregistry.outputs.AssetStatusErrorResponse): AssetStatusErrorResponse = AssetStatusErrorResponse(
            code = javaType.code().map({ args0 -> args0 }).orElse(null),
            message = javaType.message().map({ args0 -> args0 }).orElse(null),
        )
    }
}
