@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceregistry.kotlin.outputs

import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 * Defines the asset status properties.
 * @property errors Array object to transfer and persist errors that originate from the Edge.
 * @property version A read only incremental counter indicating the number of times the configuration has been modified from the perspective of the current actual (Edge) state of the Asset. Edge would be the only writer of this value and would sync back up to the cloud. In steady state, this should equal version.
 */
public data class AssetStatusResponse(
    public val errors: List<AssetStatusErrorResponse>? = null,
    public val version: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.deviceregistry.outputs.AssetStatusResponse): AssetStatusResponse = AssetStatusResponse(
            errors = javaType.errors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.deviceregistry.kotlin.outputs.AssetStatusErrorResponse.Companion.toKotlin(args0)
                })
            }),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
