@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the data point properties.
 * @property capabilityId The path to the type definition of the capability (e.g. DTMI, OPC UA information model node id, etc.), for example dtmi:com:example:Robot:_contents:__prop1;1.
 * @property dataPointConfiguration Protocol-specific configuration for the data point. For OPC UA, this could include configuration like, publishingInterval, samplingInterval, and queueSize.
 * @property dataSource The address of the source of the data in the asset (e.g. URL) so that a client can access the data source on the asset.
 * @property name The name of the data point.
 * @property observabilityMode An indication of how the data point should be mapped to OpenTelemetry.
 */
public data class DataPointResponse(
    public val capabilityId: String? = null,
    public val dataPointConfiguration: String? = null,
    public val dataSource: String,
    public val name: String? = null,
    public val observabilityMode: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.deviceregistry.outputs.DataPointResponse): DataPointResponse = DataPointResponse(
            capabilityId = javaType.capabilityId().map({ args0 -> args0 }).orElse(null),
            dataPointConfiguration = javaType.dataPointConfiguration().map({ args0 -> args0 }).orElse(null),
            dataSource = javaType.dataSource(),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            observabilityMode = javaType.observabilityMode().map({ args0 -> args0 }).orElse(null),
        )
    }
}
