@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Asset Endpoint Profile definition.
 * @property additionalConfiguration Contains connectivity type specific further configuration (e.g. OPC UA, Modbus, ONVIF).
 * @property extendedLocation The extended location.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property provisioningState Provisioning state of the resource.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property targetAddress The local valid URI specifying the network address/DNS name of a southbound device. The scheme part of the targetAddress URI specifies the type of the device. The additionalConfiguration field holds further connector type specific configuration.
 * @property transportAuthentication Defines the authentication mechanism for the southbound connector connecting to the shop floor/OT device.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property userAuthentication Defines the client authentication mechanism to the server.
 * @property uuid Globally unique, immutable, non-reusable id.
 */
public data class GetAssetEndpointProfileResult(
    public val additionalConfiguration: String? = null,
    public val extendedLocation: ExtendedLocationResponse,
    public val id: String,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val targetAddress: String,
    public val transportAuthentication: TransportAuthenticationResponse? = null,
    public val type: String,
    public val userAuthentication: UserAuthenticationResponse? = null,
    public val uuid: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.deviceregistry.outputs.GetAssetEndpointProfileResult): GetAssetEndpointProfileResult = GetAssetEndpointProfileResult(
            additionalConfiguration = javaType.additionalConfiguration().map({ args0 -> args0 }).orElse(null),
            extendedLocation = javaType.extendedLocation().let({ args0 ->
                com.pulumi.azurenative.deviceregistry.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
            }),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.deviceregistry.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            targetAddress = javaType.targetAddress(),
            transportAuthentication = javaType.transportAuthentication().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.deviceregistry.kotlin.outputs.TransportAuthenticationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
            userAuthentication = javaType.userAuthentication().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.deviceregistry.kotlin.outputs.UserAuthenticationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            uuid = javaType.uuid(),
        )
    }
}
