@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Certificate or private key that can be used by the southbound connector connecting to the shop floor/OT device. The accepted extensions are .der for certificates and .pfx/.pem for private keys.
 * @property certPasswordReference Secret Reference Name (Pfx or Pem password).
 * @property certSecretReference Secret Reference name (cert and private key).
 * @property certThumbprint Certificate thumbprint.
 */
public data class OwnCertificateResponse(
    public val certPasswordReference: String? = null,
    public val certSecretReference: String? = null,
    public val certThumbprint: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.deviceregistry.outputs.OwnCertificateResponse): OwnCertificateResponse = OwnCertificateResponse(
            certPasswordReference = javaType.certPasswordReference().map({ args0 -> args0 }).orElse(null),
            certSecretReference = javaType.certSecretReference().map({ args0 -> args0 }).orElse(null),
            certThumbprint = javaType.certThumbprint().map({ args0 -> args0 }).orElse(null),
        )
    }
}
