@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Definition of the client authentication mechanism to the server.
 * @property mode Defines the mode to authenticate the user of the client at the server.
 * @property usernamePasswordCredentials Defines the username and password references when UsernamePassword user authentication mode is selected.
 * @property x509Credentials Defines the certificate reference when Certificate user authentication mode is selected.
 */
public data class UserAuthenticationResponse(
    public val mode: String,
    public val usernamePasswordCredentials: UsernamePasswordCredentialsResponse? = null,
    public val x509Credentials: X509CredentialsResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.deviceregistry.outputs.UserAuthenticationResponse): UserAuthenticationResponse = UserAuthenticationResponse(
            mode = javaType.mode(),
            usernamePasswordCredentials = javaType.usernamePasswordCredentials().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.deviceregistry.kotlin.outputs.UsernamePasswordCredentialsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            x509Credentials = javaType.x509Credentials().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.deviceregistry.kotlin.outputs.X509CredentialsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
