@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The credentials for authentication mode UsernamePassword.
 * @property passwordReference A reference to secret containing the password.
 * @property usernameReference A reference to secret containing the username.
 */
public data class UsernamePasswordCredentialsResponse(
    public val passwordReference: String,
    public val usernameReference: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.deviceregistry.outputs.UsernamePasswordCredentialsResponse): UsernamePasswordCredentialsResponse = UsernamePasswordCredentialsResponse(
            passwordReference = javaType.passwordReference(),
            usernameReference = javaType.usernameReference(),
        )
    }
}
