@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The x509 certificate for authentication mode Certificate.
 * @property certificateReference A reference to secret containing the certificate and private key (e.g. stored as .der/.pem or .der/.pfx).
 */
public data class X509CredentialsResponse(
    public val certificateReference: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.deviceregistry.outputs.X509CredentialsResponse): X509CredentialsResponse = X509CredentialsResponse(
            certificateReference = javaType.certificateReference(),
        )
    }
}
