@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin

import com.pulumi.azurenative.devices.DevicesFunctions.getCertificatePlain
import com.pulumi.azurenative.devices.DevicesFunctions.getDpsCertificatePlain
import com.pulumi.azurenative.devices.DevicesFunctions.getIotDpsResourcePlain
import com.pulumi.azurenative.devices.DevicesFunctions.getIotDpsResourcePrivateEndpointConnectionPlain
import com.pulumi.azurenative.devices.DevicesFunctions.getIotHubResourceEventHubConsumerGroupPlain
import com.pulumi.azurenative.devices.DevicesFunctions.getIotHubResourcePlain
import com.pulumi.azurenative.devices.DevicesFunctions.getPrivateEndpointConnectionPlain
import com.pulumi.azurenative.devices.DevicesFunctions.listIotDpsResourceKeysForKeyNamePlain
import com.pulumi.azurenative.devices.DevicesFunctions.listIotDpsResourceKeysPlain
import com.pulumi.azurenative.devices.DevicesFunctions.listIotHubResourceKeysForKeyNamePlain
import com.pulumi.azurenative.devices.DevicesFunctions.listIotHubResourceKeysPlain
import com.pulumi.azurenative.devices.kotlin.inputs.GetCertificatePlainArgs
import com.pulumi.azurenative.devices.kotlin.inputs.GetCertificatePlainArgsBuilder
import com.pulumi.azurenative.devices.kotlin.inputs.GetDpsCertificatePlainArgs
import com.pulumi.azurenative.devices.kotlin.inputs.GetDpsCertificatePlainArgsBuilder
import com.pulumi.azurenative.devices.kotlin.inputs.GetIotDpsResourcePlainArgs
import com.pulumi.azurenative.devices.kotlin.inputs.GetIotDpsResourcePlainArgsBuilder
import com.pulumi.azurenative.devices.kotlin.inputs.GetIotDpsResourcePrivateEndpointConnectionPlainArgs
import com.pulumi.azurenative.devices.kotlin.inputs.GetIotDpsResourcePrivateEndpointConnectionPlainArgsBuilder
import com.pulumi.azurenative.devices.kotlin.inputs.GetIotHubResourceEventHubConsumerGroupPlainArgs
import com.pulumi.azurenative.devices.kotlin.inputs.GetIotHubResourceEventHubConsumerGroupPlainArgsBuilder
import com.pulumi.azurenative.devices.kotlin.inputs.GetIotHubResourcePlainArgs
import com.pulumi.azurenative.devices.kotlin.inputs.GetIotHubResourcePlainArgsBuilder
import com.pulumi.azurenative.devices.kotlin.inputs.GetPrivateEndpointConnectionPlainArgs
import com.pulumi.azurenative.devices.kotlin.inputs.GetPrivateEndpointConnectionPlainArgsBuilder
import com.pulumi.azurenative.devices.kotlin.inputs.ListIotDpsResourceKeysForKeyNamePlainArgs
import com.pulumi.azurenative.devices.kotlin.inputs.ListIotDpsResourceKeysForKeyNamePlainArgsBuilder
import com.pulumi.azurenative.devices.kotlin.inputs.ListIotDpsResourceKeysPlainArgs
import com.pulumi.azurenative.devices.kotlin.inputs.ListIotDpsResourceKeysPlainArgsBuilder
import com.pulumi.azurenative.devices.kotlin.inputs.ListIotHubResourceKeysForKeyNamePlainArgs
import com.pulumi.azurenative.devices.kotlin.inputs.ListIotHubResourceKeysForKeyNamePlainArgsBuilder
import com.pulumi.azurenative.devices.kotlin.inputs.ListIotHubResourceKeysPlainArgs
import com.pulumi.azurenative.devices.kotlin.inputs.ListIotHubResourceKeysPlainArgsBuilder
import com.pulumi.azurenative.devices.kotlin.outputs.GetCertificateResult
import com.pulumi.azurenative.devices.kotlin.outputs.GetDpsCertificateResult
import com.pulumi.azurenative.devices.kotlin.outputs.GetIotDpsResourcePrivateEndpointConnectionResult
import com.pulumi.azurenative.devices.kotlin.outputs.GetIotDpsResourceResult
import com.pulumi.azurenative.devices.kotlin.outputs.GetIotHubResourceEventHubConsumerGroupResult
import com.pulumi.azurenative.devices.kotlin.outputs.GetIotHubResourceResult
import com.pulumi.azurenative.devices.kotlin.outputs.GetPrivateEndpointConnectionResult
import com.pulumi.azurenative.devices.kotlin.outputs.ListIotDpsResourceKeysForKeyNameResult
import com.pulumi.azurenative.devices.kotlin.outputs.ListIotDpsResourceKeysResult
import com.pulumi.azurenative.devices.kotlin.outputs.ListIotHubResourceKeysForKeyNameResult
import com.pulumi.azurenative.devices.kotlin.outputs.ListIotHubResourceKeysResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.devices.kotlin.outputs.GetCertificateResult.Companion.toKotlin as getCertificateResultToKotlin
import com.pulumi.azurenative.devices.kotlin.outputs.GetDpsCertificateResult.Companion.toKotlin as getDpsCertificateResultToKotlin
import com.pulumi.azurenative.devices.kotlin.outputs.GetIotDpsResourcePrivateEndpointConnectionResult.Companion.toKotlin as getIotDpsResourcePrivateEndpointConnectionResultToKotlin
import com.pulumi.azurenative.devices.kotlin.outputs.GetIotDpsResourceResult.Companion.toKotlin as getIotDpsResourceResultToKotlin
import com.pulumi.azurenative.devices.kotlin.outputs.GetIotHubResourceEventHubConsumerGroupResult.Companion.toKotlin as getIotHubResourceEventHubConsumerGroupResultToKotlin
import com.pulumi.azurenative.devices.kotlin.outputs.GetIotHubResourceResult.Companion.toKotlin as getIotHubResourceResultToKotlin
import com.pulumi.azurenative.devices.kotlin.outputs.GetPrivateEndpointConnectionResult.Companion.toKotlin as getPrivateEndpointConnectionResultToKotlin
import com.pulumi.azurenative.devices.kotlin.outputs.ListIotDpsResourceKeysForKeyNameResult.Companion.toKotlin as listIotDpsResourceKeysForKeyNameResultToKotlin
import com.pulumi.azurenative.devices.kotlin.outputs.ListIotDpsResourceKeysResult.Companion.toKotlin as listIotDpsResourceKeysResultToKotlin
import com.pulumi.azurenative.devices.kotlin.outputs.ListIotHubResourceKeysForKeyNameResult.Companion.toKotlin as listIotHubResourceKeysForKeyNameResultToKotlin
import com.pulumi.azurenative.devices.kotlin.outputs.ListIotHubResourceKeysResult.Companion.toKotlin as listIotHubResourceKeysResultToKotlin

public object DevicesFunctions {
    /**
     * Returns the certificate.
     * Azure REST API version: 2022-04-30-preview.
     * Other available API versions: 2020-04-01, 2022-11-15-preview, 2023-06-30, 2023-06-30-preview.
     * @param argument null
     * @return The X509 Certificate.
     */
    public suspend fun getCertificate(argument: GetCertificatePlainArgs): GetCertificateResult =
        getCertificateResultToKotlin(getCertificatePlain(argument.toJava()).await())

    /**
     * @see [getCertificate].
     * @param certificateName The name of the certificate
     * @param resourceGroupName The name of the resource group that contains the IoT hub.
     * @param resourceName The name of the IoT hub.
     * @return The X509 Certificate.
     */
    public suspend fun getCertificate(
        certificateName: String,
        resourceGroupName: String,
        resourceName: String,
    ): GetCertificateResult {
        val argument = GetCertificatePlainArgs(
            certificateName = certificateName,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getCertificateResultToKotlin(getCertificatePlain(argument.toJava()).await())
    }

    /**
     * @see [getCertificate].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;devices&#46;kotlin&#46;inputs&#46;GetCertificatePlainArgs].
     * @return The X509 Certificate.
     */
    public suspend fun getCertificate(argument: suspend GetCertificatePlainArgsBuilder.() -> Unit): GetCertificateResult {
        val builder = GetCertificatePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCertificateResultToKotlin(getCertificatePlain(builtArgument.toJava()).await())
    }

    /**
     * Get the certificate from the provisioning service.
     * Azure REST API version: 2022-12-12.
     * Other available API versions: 2021-10-15, 2023-03-01-preview.
     * @param argument null
     * @return The X509 Certificate.
     */
    public suspend fun getDpsCertificate(argument: GetDpsCertificatePlainArgs): GetDpsCertificateResult =
        getDpsCertificateResultToKotlin(getDpsCertificatePlain(argument.toJava()).await())

    /**
     * @see [getDpsCertificate].
     * @param certificateName Name of the certificate to retrieve.
     * @param provisioningServiceName Name of the provisioning service the certificate is associated with.
     * @param resourceGroupName Resource group identifier.
     * @return The X509 Certificate.
     */
    public suspend fun getDpsCertificate(
        certificateName: String,
        provisioningServiceName: String,
        resourceGroupName: String,
    ): GetDpsCertificateResult {
        val argument = GetDpsCertificatePlainArgs(
            certificateName = certificateName,
            provisioningServiceName = provisioningServiceName,
            resourceGroupName = resourceGroupName,
        )
        return getDpsCertificateResultToKotlin(getDpsCertificatePlain(argument.toJava()).await())
    }

    /**
     * @see [getDpsCertificate].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;devices&#46;kotlin&#46;inputs&#46;GetDpsCertificatePlainArgs].
     * @return The X509 Certificate.
     */
    public suspend fun getDpsCertificate(argument: suspend GetDpsCertificatePlainArgsBuilder.() -> Unit): GetDpsCertificateResult {
        val builder = GetDpsCertificatePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDpsCertificateResultToKotlin(getDpsCertificatePlain(builtArgument.toJava()).await())
    }

    /**
     * Get the metadata of the provisioning service without SAS keys.
     * Azure REST API version: 2022-12-12.
     * Other available API versions: 2020-09-01-preview, 2023-03-01-preview.
     * @param argument null
     * @return The description of the provisioning service.
     */
    public suspend fun getIotDpsResource(argument: GetIotDpsResourcePlainArgs): GetIotDpsResourceResult =
        getIotDpsResourceResultToKotlin(getIotDpsResourcePlain(argument.toJava()).await())

    /**
     * @see [getIotDpsResource].
     * @param provisioningServiceName Name of the provisioning service to retrieve.
     * @param resourceGroupName Resource group name.
     * @return The description of the provisioning service.
     */
    public suspend fun getIotDpsResource(provisioningServiceName: String, resourceGroupName: String): GetIotDpsResourceResult {
        val argument = GetIotDpsResourcePlainArgs(
            provisioningServiceName = provisioningServiceName,
            resourceGroupName = resourceGroupName,
        )
        return getIotDpsResourceResultToKotlin(getIotDpsResourcePlain(argument.toJava()).await())
    }

    /**
     * @see [getIotDpsResource].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;devices&#46;kotlin&#46;inputs&#46;GetIotDpsResourcePlainArgs].
     * @return The description of the provisioning service.
     */
    public suspend fun getIotDpsResource(argument: suspend GetIotDpsResourcePlainArgsBuilder.() -> Unit): GetIotDpsResourceResult {
        val builder = GetIotDpsResourcePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIotDpsResourceResultToKotlin(getIotDpsResourcePlain(builtArgument.toJava()).await())
    }

    /**
     * Get private endpoint connection properties
     * Azure REST API version: 2022-12-12.
     * Other available API versions: 2023-03-01-preview.
     * @param argument null
     * @return The private endpoint connection of a provisioning service
     */
    public suspend fun getIotDpsResourcePrivateEndpointConnection(argument: GetIotDpsResourcePrivateEndpointConnectionPlainArgs): GetIotDpsResourcePrivateEndpointConnectionResult =
        getIotDpsResourcePrivateEndpointConnectionResultToKotlin(getIotDpsResourcePrivateEndpointConnectionPlain(argument.toJava()).await())

    /**
     * @see [getIotDpsResourcePrivateEndpointConnection].
     * @param privateEndpointConnectionName The name of the private endpoint connection
     * @param resourceGroupName The name of the resource group that contains the provisioning service.
     * @param resourceName The name of the provisioning service.
     * @return The private endpoint connection of a provisioning service
     */
    public suspend fun getIotDpsResourcePrivateEndpointConnection(
        privateEndpointConnectionName: String,
        resourceGroupName: String,
        resourceName: String,
    ): GetIotDpsResourcePrivateEndpointConnectionResult {
        val argument = GetIotDpsResourcePrivateEndpointConnectionPlainArgs(
            privateEndpointConnectionName = privateEndpointConnectionName,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getIotDpsResourcePrivateEndpointConnectionResultToKotlin(getIotDpsResourcePrivateEndpointConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getIotDpsResourcePrivateEndpointConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;devices&#46;kotlin&#46;inputs&#46;GetIotDpsResourcePrivateEndpointConnectionPlainArgs].
     * @return The private endpoint connection of a provisioning service
     */
    public suspend fun getIotDpsResourcePrivateEndpointConnection(argument: suspend GetIotDpsResourcePrivateEndpointConnectionPlainArgsBuilder.() -> Unit): GetIotDpsResourcePrivateEndpointConnectionResult {
        val builder = GetIotDpsResourcePrivateEndpointConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIotDpsResourcePrivateEndpointConnectionResultToKotlin(getIotDpsResourcePrivateEndpointConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the non-security related metadata of an IoT hub.
     * Azure REST API version: 2022-04-30-preview.
     * Other available API versions: 2017-07-01, 2022-11-15-preview, 2023-06-30, 2023-06-30-preview.
     * @param argument null
     * @return The description of the IoT hub.
     */
    public suspend fun getIotHubResource(argument: GetIotHubResourcePlainArgs): GetIotHubResourceResult =
        getIotHubResourceResultToKotlin(getIotHubResourcePlain(argument.toJava()).await())

    /**
     * @see [getIotHubResource].
     * @param resourceGroupName The name of the resource group that contains the IoT hub.
     * @param resourceName The name of the IoT hub.
     * @return The description of the IoT hub.
     */
    public suspend fun getIotHubResource(resourceGroupName: String, resourceName: String): GetIotHubResourceResult {
        val argument = GetIotHubResourcePlainArgs(
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getIotHubResourceResultToKotlin(getIotHubResourcePlain(argument.toJava()).await())
    }

    /**
     * @see [getIotHubResource].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;devices&#46;kotlin&#46;inputs&#46;GetIotHubResourcePlainArgs].
     * @return The description of the IoT hub.
     */
    public suspend fun getIotHubResource(argument: suspend GetIotHubResourcePlainArgsBuilder.() -> Unit): GetIotHubResourceResult {
        val builder = GetIotHubResourcePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIotHubResourceResultToKotlin(getIotHubResourcePlain(builtArgument.toJava()).await())
    }

    /**
     * Get a consumer group from the Event Hub-compatible device-to-cloud endpoint for an IoT hub.
     * Azure REST API version: 2022-04-30-preview.
     * Other available API versions: 2017-07-01, 2021-03-03-preview, 2022-11-15-preview, 2023-06-30, 2023-06-30-preview.
     * @param argument null
     * @return The properties of the EventHubConsumerGroupInfo object.
     */
    public suspend fun getIotHubResourceEventHubConsumerGroup(argument: GetIotHubResourceEventHubConsumerGroupPlainArgs): GetIotHubResourceEventHubConsumerGroupResult =
        getIotHubResourceEventHubConsumerGroupResultToKotlin(getIotHubResourceEventHubConsumerGroupPlain(argument.toJava()).await())

    /**
     * @see [getIotHubResourceEventHubConsumerGroup].
     * @param eventHubEndpointName The name of the Event Hub-compatible endpoint in the IoT hub.
     * @param name The name of the consumer group to retrieve.
     * @param resourceGroupName The name of the resource group that contains the IoT hub.
     * @param resourceName The name of the IoT hub.
     * @return The properties of the EventHubConsumerGroupInfo object.
     */
    public suspend fun getIotHubResourceEventHubConsumerGroup(
        eventHubEndpointName: String,
        name: String,
        resourceGroupName: String,
        resourceName: String,
    ): GetIotHubResourceEventHubConsumerGroupResult {
        val argument = GetIotHubResourceEventHubConsumerGroupPlainArgs(
            eventHubEndpointName = eventHubEndpointName,
            name = name,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getIotHubResourceEventHubConsumerGroupResultToKotlin(getIotHubResourceEventHubConsumerGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getIotHubResourceEventHubConsumerGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;devices&#46;kotlin&#46;inputs&#46;GetIotHubResourceEventHubConsumerGroupPlainArgs].
     * @return The properties of the EventHubConsumerGroupInfo object.
     */
    public suspend fun getIotHubResourceEventHubConsumerGroup(argument: suspend GetIotHubResourceEventHubConsumerGroupPlainArgsBuilder.() -> Unit): GetIotHubResourceEventHubConsumerGroupResult {
        val builder = GetIotHubResourceEventHubConsumerGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIotHubResourceEventHubConsumerGroupResultToKotlin(getIotHubResourceEventHubConsumerGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Get private endpoint connection properties
     * Azure REST API version: 2022-04-30-preview.
     * Other available API versions: 2022-11-15-preview, 2023-06-30, 2023-06-30-preview.
     * @param argument null
     * @return The private endpoint connection of an IotHub
     */
    public suspend fun getPrivateEndpointConnection(argument: GetPrivateEndpointConnectionPlainArgs): GetPrivateEndpointConnectionResult =
        getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnection].
     * @param privateEndpointConnectionName The name of the private endpoint connection
     * @param resourceGroupName The name of the resource group that contains the IoT hub.
     * @param resourceName The name of the IoT hub.
     * @return The private endpoint connection of an IotHub
     */
    public suspend fun getPrivateEndpointConnection(
        privateEndpointConnectionName: String,
        resourceGroupName: String,
        resourceName: String,
    ): GetPrivateEndpointConnectionResult {
        val argument = GetPrivateEndpointConnectionPlainArgs(
            privateEndpointConnectionName = privateEndpointConnectionName,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;devices&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionPlainArgs].
     * @return The private endpoint connection of an IotHub
     */
    public suspend fun getPrivateEndpointConnection(argument: suspend GetPrivateEndpointConnectionPlainArgsBuilder.() -> Unit): GetPrivateEndpointConnectionResult {
        val builder = GetPrivateEndpointConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * List the primary and secondary keys for a provisioning service.
     * Azure REST API version: 2022-12-12.
     * Other available API versions: 2020-09-01-preview, 2023-03-01-preview.
     * @param argument null
     * @return List of shared access keys.
     */
    public suspend fun listIotDpsResourceKeys(argument: ListIotDpsResourceKeysPlainArgs): ListIotDpsResourceKeysResult =
        listIotDpsResourceKeysResultToKotlin(listIotDpsResourceKeysPlain(argument.toJava()).await())

    /**
     * @see [listIotDpsResourceKeys].
     * @param provisioningServiceName The provisioning service name to get the shared access keys for.
     * @param resourceGroupName resource group name
     * @return List of shared access keys.
     */
    public suspend fun listIotDpsResourceKeys(
        provisioningServiceName: String,
        resourceGroupName: String,
    ): ListIotDpsResourceKeysResult {
        val argument = ListIotDpsResourceKeysPlainArgs(
            provisioningServiceName = provisioningServiceName,
            resourceGroupName = resourceGroupName,
        )
        return listIotDpsResourceKeysResultToKotlin(listIotDpsResourceKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listIotDpsResourceKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;devices&#46;kotlin&#46;inputs&#46;ListIotDpsResourceKeysPlainArgs].
     * @return List of shared access keys.
     */
    public suspend fun listIotDpsResourceKeys(argument: suspend ListIotDpsResourceKeysPlainArgsBuilder.() -> Unit): ListIotDpsResourceKeysResult {
        val builder = ListIotDpsResourceKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listIotDpsResourceKeysResultToKotlin(listIotDpsResourceKeysPlain(builtArgument.toJava()).await())
    }

    /**
     * List primary and secondary keys for a specific key name
     * Azure REST API version: 2022-12-12.
     * Other available API versions: 2020-09-01-preview, 2023-03-01-preview.
     * @param argument null
     * @return Description of the shared access key.
     */
    public suspend fun listIotDpsResourceKeysForKeyName(argument: ListIotDpsResourceKeysForKeyNamePlainArgs): ListIotDpsResourceKeysForKeyNameResult =
        listIotDpsResourceKeysForKeyNameResultToKotlin(listIotDpsResourceKeysForKeyNamePlain(argument.toJava()).await())

    /**
     * @see [listIotDpsResourceKeysForKeyName].
     * @param keyName Logical key name to get key-values for.
     * @param provisioningServiceName Name of the provisioning service.
     * @param resourceGroupName The name of the resource group that contains the provisioning service.
     * @return Description of the shared access key.
     */
    public suspend fun listIotDpsResourceKeysForKeyName(
        keyName: String,
        provisioningServiceName: String,
        resourceGroupName: String,
    ): ListIotDpsResourceKeysForKeyNameResult {
        val argument = ListIotDpsResourceKeysForKeyNamePlainArgs(
            keyName = keyName,
            provisioningServiceName = provisioningServiceName,
            resourceGroupName = resourceGroupName,
        )
        return listIotDpsResourceKeysForKeyNameResultToKotlin(listIotDpsResourceKeysForKeyNamePlain(argument.toJava()).await())
    }

    /**
     * @see [listIotDpsResourceKeysForKeyName].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;devices&#46;kotlin&#46;inputs&#46;ListIotDpsResourceKeysForKeyNamePlainArgs].
     * @return Description of the shared access key.
     */
    public suspend fun listIotDpsResourceKeysForKeyName(argument: suspend ListIotDpsResourceKeysForKeyNamePlainArgsBuilder.() -> Unit): ListIotDpsResourceKeysForKeyNameResult {
        val builder = ListIotDpsResourceKeysForKeyNamePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listIotDpsResourceKeysForKeyNameResultToKotlin(listIotDpsResourceKeysForKeyNamePlain(builtArgument.toJava()).await())
    }

    /**
     * Get the security metadata for an IoT hub. For more information, see: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-security.
     * Azure REST API version: 2022-04-30-preview.
     * Other available API versions: 2017-07-01, 2022-11-15-preview, 2023-06-30, 2023-06-30-preview.
     * @param argument null
     * @return The list of shared access policies with a next link.
     */
    public suspend fun listIotHubResourceKeys(argument: ListIotHubResourceKeysPlainArgs): ListIotHubResourceKeysResult =
        listIotHubResourceKeysResultToKotlin(listIotHubResourceKeysPlain(argument.toJava()).await())

    /**
     * @see [listIotHubResourceKeys].
     * @param resourceGroupName The name of the resource group that contains the IoT hub.
     * @param resourceName The name of the IoT hub.
     * @return The list of shared access policies with a next link.
     */
    public suspend fun listIotHubResourceKeys(resourceGroupName: String, resourceName: String): ListIotHubResourceKeysResult {
        val argument = ListIotHubResourceKeysPlainArgs(
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return listIotHubResourceKeysResultToKotlin(listIotHubResourceKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listIotHubResourceKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;devices&#46;kotlin&#46;inputs&#46;ListIotHubResourceKeysPlainArgs].
     * @return The list of shared access policies with a next link.
     */
    public suspend fun listIotHubResourceKeys(argument: suspend ListIotHubResourceKeysPlainArgsBuilder.() -> Unit): ListIotHubResourceKeysResult {
        val builder = ListIotHubResourceKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listIotHubResourceKeysResultToKotlin(listIotHubResourceKeysPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a shared access policy by name from an IoT hub. For more information, see: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-security.
     * Azure REST API version: 2022-04-30-preview.
     * Other available API versions: 2017-07-01, 2022-11-15-preview, 2023-06-30, 2023-06-30-preview.
     * @param argument null
     * @return The properties of an IoT hub shared access policy.
     */
    public suspend fun listIotHubResourceKeysForKeyName(argument: ListIotHubResourceKeysForKeyNamePlainArgs): ListIotHubResourceKeysForKeyNameResult =
        listIotHubResourceKeysForKeyNameResultToKotlin(listIotHubResourceKeysForKeyNamePlain(argument.toJava()).await())

    /**
     * @see [listIotHubResourceKeysForKeyName].
     * @param keyName The name of the shared access policy.
     * @param resourceGroupName The name of the resource group that contains the IoT hub.
     * @param resourceName The name of the IoT hub.
     * @return The properties of an IoT hub shared access policy.
     */
    public suspend fun listIotHubResourceKeysForKeyName(
        keyName: String,
        resourceGroupName: String,
        resourceName: String,
    ): ListIotHubResourceKeysForKeyNameResult {
        val argument = ListIotHubResourceKeysForKeyNamePlainArgs(
            keyName = keyName,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return listIotHubResourceKeysForKeyNameResultToKotlin(listIotHubResourceKeysForKeyNamePlain(argument.toJava()).await())
    }

    /**
     * @see [listIotHubResourceKeysForKeyName].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;devices&#46;kotlin&#46;inputs&#46;ListIotHubResourceKeysForKeyNamePlainArgs].
     * @return The properties of an IoT hub shared access policy.
     */
    public suspend fun listIotHubResourceKeysForKeyName(argument: suspend ListIotHubResourceKeysForKeyNamePlainArgsBuilder.() -> Unit): ListIotHubResourceKeysForKeyNameResult {
        val builder = ListIotHubResourceKeysForKeyNamePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listIotHubResourceKeysForKeyNameResultToKotlin(listIotHubResourceKeysForKeyNamePlain(builtArgument.toJava()).await())
    }
}
